###################################################
### chunk number 1: LibraryPreload
###################################################
#line 52 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
options(width=60)
library(xcms)
library(TargetSearch)
library(TargetSearchData)


###################################################
### chunk number 2: ImportSample
###################################################
#line 107 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
library(TargetSearchData)
library(TargetSearch)
cdf.path <- system.file("gc-ms-data", package = "TargetSearchData")
sample.file <- file.path(cdf.path, "samples.txt")
samples <- ImportSamples(sample.file, CDFpath = cdf.path, RIpath = ".")


###################################################
### chunk number 3: ImportSample2
###################################################
#line 118 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
cdffiles <- dir(cdf.path, pattern="cdf$")
# define the RI file names
rifiles  <- paste("RI_", sub("cdf","txt", cdffiles), sep = "")
# take the measurement day info from the cdf file names.
days <- sub("^([[:digit:]]+).*$","\\1",cdffiles)
# sample names 
smp_names <- sub("\\.cdf", "", cdffiles)
# add some sample info
smp_data <- data.frame(CDF_FILE =cdffiles, GROUP = gl(5,3))
# create the sample object
samples <- new("tsSample", Names = smp_names, CDFfiles = cdffiles,
               CDFpath = cdf.path, RIpath = ".", days = days,
               RIfiles = rifiles, data = smp_data)


###################################################
### chunk number 4: ImportFameSettings
###################################################
#line 143 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
rim.file  <- file.path(cdf.path, "rimLimits.txt")
rimLimits <- ImportFameSettings(rim.file, mass = 87)


###################################################
### chunk number 5: RIcorrection
###################################################
#line 185 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
RImatrix <- RIcorrect(samples, rimLimits, massRange = c(85,500),
            IntThreshold = 10, pp.method = "smoothing", Window = 7)


###################################################
### chunk number 6: PeakIdentification
###################################################
#line 212 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
outliers <- FAMEoutliers(samples, RImatrix, threshold = 3)


###################################################
### chunk number 7: plotFAME
###################################################
#line 222 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
plotFAME(samples, RImatrix, 1)


###################################################
### chunk number 8: ImportLibrary
###################################################
#line 277 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
lib.file <- file.path(cdf.path, "library.txt")
lib      <- ImportLibrary(lib.file, RI_dev = c(2000,1000,200),
            TopMasses = 15, ExcludeMasses = c(147, 148, 149))


###################################################
### chunk number 9: LibrarySearch1
###################################################
#line 299 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
lib <- medianRILib(samples, lib)


###################################################
### chunk number 10: medianLib
###################################################
#line 310 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
resPeaks <- FindPeaks(RIfiles(samples), refLib(lib, w = 1, sel = TRUE))
plotRIdev(lib, resPeaks, libId = 1:9)


###################################################
### chunk number 11: LibrarySearch2
###################################################
#line 328 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
cor_RI <- sampleRI(samples, lib, r_thres = 0.95,
                     method = "dayNorm")


###################################################
### chunk number 12: LibrarySearch3
###################################################
#line 339 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
peakData <- peakFind(samples, lib, cor_RI)


###################################################
### chunk number 13: LibrarySearch4
###################################################
#line 350 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
met.RI        <- retIndex(peakData)
met.Intensity <- Intensity(peakData)
# show the intensity values of the first metabolite.
met.Intensity[[1]]


###################################################
### chunk number 14: MetaboliteProfile
###################################################
#line 365 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
MetabProfile <- Profile(samples, lib, peakData, r_thres = 0.95,
                      method = "dayNorm")


###################################################
### chunk number 15: MetaboliteProfile2
###################################################
#line 421 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
finalProfile <- ProfileCleanUp(MetabProfile, timeSplit = 500,
                                r_thres = 0.95)


###################################################
### chunk number 16: plotSpectra
###################################################
#line 445 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
grep("Valine", libName(lib))
plotSpectra(lib, peakData, libId = 3, type = "ht")


###################################################
### chunk number 17: plotPeak
###################################################
#line 458 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
# select "Valine" top masses
top.masses <- topMass(lib)[[3]]
# we select the first sample
sample.id <- 1
cdf.file  <- file.path(cdf.path, cdffiles[sample.id])
rawpeaks  <- peakCDFextraction(cdf.file, massRange = c(85,500))
plotPeak(rawpeaks, time.range = libRI(lib)[3] + c(-2000,2000),
    masses = top.masses, useRI = TRUE, rimTime = RImatrix[,sample.id],
    standard = rimStandard(rimLimits), massRange = c(85, 500),
    main = "Valine")


###################################################
### chunk number 18: untargeted1
###################################################
#line 559 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
metRI    <- seq(200000, 300000, by = 5000)
metMZ    <- 85:250
metNames <- paste("Metab",format(metRI,digits=6), sep = "_")


###################################################
### chunk number 19: untargeted2
###################################################
#line 570 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
metLib   <- new("tsLib", Name = metNames, RI = metRI,
     selMass = rep(list(metMZ), length(metRI)), RIdev = c(3000, 1500, 500))


###################################################
### chunk number 20: untargeted3
###################################################
#line 578 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
metLib <- medianRILib(samples, metLib)
metCorRI <- sampleRI(samples, metLib)
metPeakData <- peakFind(samples, metLib, metCorRI)
metProfile <- Profile(samples, metLib, metPeakData)
metFinProf <- ProfileCleanUp(metProfile, timeSplit = 500)


###################################################
### chunk number 21: untargeted4
###################################################
#line 591 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpAvp0un/R.INSTALL5e38a18/TargetSearch/inst/doc/TargetSearch.Rnw"
sum(  profileInfo(metFinProf)$Mass_count > 5)
tmp   <-  profileInfo(metFinProf)$Mass_count > 5
metRI    <- profileInfo(metFinProf)$RI[tmp]
metNames <-  as.character( profileInfo(metFinProf)$Name[tmp] )
metMZ <- sapply(profileInfo(metFinProf)$Masses[tmp],
	function(x) as.numeric(unlist(strsplit(x,";"))) )
metLib   <- new("tsLib", Name = metNames, RI = metRI,
     selMass = metMZ, RIdev = c(1500, 750, 250))


