###################################################
### chunk number 1: lib
###################################################
#line 84 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
library(RpsiXML)
library(ppiStats)
library(Rgraphviz)
library(RBGL)


###################################################
### chunk number 2: parse
###################################################
#line 101 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
xmlDir <- system.file("/extdata/psi25files",package="RpsiXML")
intactxml <- file.path(xmlDir, "intact_2008_test.xml")
x <- psimi25XML2Graph(intactxml, INTACT.PSIMI25, verbose=FALSE)


###################################################
### chunk number 3: visGraph
###################################################
#line 107 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
nA <- makeNodeAttrs(x, label="", fillcolor="lightblue", width=0.4, height=0.4)
plot(x, "neato", nodeAttrs=nA)


###################################################
### chunk number 4: removeSelfLoop
###################################################
#line 112 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
xn <- removeSelfLoops(x)
nA <- makeNodeAttrs(xn, label="", fillcolor="lightblue", width=0.4, height=0.4)
plot(xn, "neato", nodeAttrs=nA)


###################################################
### chunk number 5: detectSelfLoop
###################################################
#line 130 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
isSelf <- function(g) {
  ns <- nodes(g)
  sapply(ns, function(x) x %in% adj(g, x)[[1]])
}
isSelfLoop <- isSelf(x)
selfCount <- sum(isSelfLoop)
print(selfCount)


###################################################
### chunk number 6: outdHist
###################################################
#line 146 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
opar <- par(mar=c(4,4,0,1))
ds <- degree(xn)
hist(ds[[2]], xlab="", main="")


###################################################
### chunk number 7: indHist
###################################################
#line 152 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
opar <- par(mar=c(4,4,0,1))
hist(ds[[1]], xlab="", main="")


###################################################
### chunk number 8: findClique
###################################################
#line 176 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
xu <- ugraph(xn)
cls <- maxClique(xu)$maxCliques
cs <- sapply(cls,length)
cls[cs==max(cs)]


###################################################
### chunk number 9: countClique
###################################################
#line 183 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
cc <- table(cs)
c4 <- cc[["4"]]
c3 <- cc[["3"]]


###################################################
### chunk number 10: visClique
###################################################
#line 189 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
c4ns <- cls[cs==max(cs)]
c4a <- c4ns[[1]]
c4b <- c4ns[[2]]
ns <- nodes(xn); ncols <- rep("lightblue", length(ns))
ncols[ns %in% c4a] <- "#FF0033"
ncols[ns %in% c4b] <- "#FFFF33"
ncols[ns %in% intersect(c4a,c4b)] <- "#FF8033"
nA <- makeNodeAttrs(xn, fillcolor=ncols, label="",width=0.4, height=0.4)
plot(xn, "neato", nodeAttrs=nA)


###################################################
### chunk number 11: visCliqueAlone
###################################################
#line 201 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
c4nodes <- unique(c(c4a, c4b))
c4sub <- subGraph(c4nodes, xn)
ns <- nodes(c4sub); ncols <- rep("lightblue", length(ns))
ncols[ns %in% c4a] <- "#FF0033"
ncols[ns %in% c4b] <- "#FFFF33"
ncols[ns %in% intersect(c4a,c4b)] <- "#FF8033"
nA <- makeNodeAttrs(c4sub, fillcolor=ncols)
plot(c4sub, "neato", nodeAttrs=nA)


###################################################
### chunk number 12: assessSym
###################################################
#line 233 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
sym <- assessSymmetry(xn, bpGraph=TRUE)
head(sym$deg)


###################################################
### chunk number 13: symStat
###################################################
#line 243 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
deg <- sym[[1]]
outR <- deg[,2]==0
inR <- deg[,3]==0
nrCount <- outR & inR


###################################################
### chunk number 14: est
###################################################
#line 265 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
nint <- 49:56
nrec <- sum(deg[,1])
nunr <- sum(deg[,2])
ntot <- nrow(deg)
est <- estErrProbMethodOfMoments(nint=nint, nrec=nrec, nunr=nunr, ntot=ntot)
plot(est[, c("pfp2", "pfn2")], type="l", col="orange", lwd=2,
     xlab=expression(p[FP]), ylab=expression(p[FN]), 
     xlim=c(-0.001, 0.005), ylim=c(-0.001, 0.045))
abline(h=0, v=0, lty=2)


###################################################
### chunk number 15: unload
###################################################
#line 287 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
library(RpsiXML)


###################################################
### chunk number 16: sessionInfo
###################################################
#line 312 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmps0suDc/R.INSTALL79659d/RpsiXML/inst/doc/RpsiXMLApp.Rnw"
sessionInfo()


