###################################################
### chunk number 1: Load package
###################################################
#line 159 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
library(Rmagpie)


###################################################
### chunk number 2: Create genesubsets fast
###################################################
#line 212 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
geneSubsets <- new("geneSubsets", speed="high", maxSubsetSize=20)
geneSubsets


###################################################
### chunk number 3: Create genesubsets slow
###################################################
#line 216 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
geneSubsets <- new("geneSubsets", speed="slow", maxSubsetSize=20)
geneSubsets


###################################################
### chunk number 4: Gene subsets Option values
###################################################
#line 223 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
geneSubsets <- new("geneSubsets", speed="high", optionValues=c(1,2,3,5,9,10,15,20))
geneSubsets


###################################################
### chunk number 5: Specify thresholds
###################################################
#line 254 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
thresholds <- new("thresholds", optionValues=c(0,0.1,0.2,0.3,0.4,0.5,1,2))


###################################################
### chunk number 6: Load Dataset
###################################################
#line 285 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
data('vV70genesDataset')


###################################################
### chunk number 7: Assessment object One
###################################################
#line 294 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
myAssessment <- new ( "assessment",
                        dataset = vV70genes,
                        noFolds1stLayer = 9,
                        noFolds2ndLayer = 10,
                        classifierName = "svm",
                        featureSelectionMethod = 'rfe',
                        typeFoldCreation = "original",
                        svmKernel = "linear",
                        noOfRepeats = 3)
myAssessment


###################################################
### chunk number 8: Assessment object two
###################################################
#line 310 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
myAssessment2 <- new ( "assessment",
                         dataset = vV70genes,
                         noFolds1stLayer = 9,
                         noFolds2ndLayer = 10,
                         classifierName = "nsc",
                         featureSelectionMethod = 'nsc',
                         typeFoldCreation = "original",
                         noOfRepeats = 2)
myAssessment2


###################################################
### chunk number 9: One layer cross validation
###################################################
#line 341 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
# Necessary to find the same results
set.seed(234)
myAssessment <- runOneLayerExtCV(myAssessment)
myAssessment


###################################################
### chunk number 10: Two layer cross validation
###################################################
#line 374 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
myAssessment <- runTwoLayerExtCV(myAssessment)
myAssessment


###################################################
### chunk number 11: Classify observations
###################################################
#line 400 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
myAssessment <- findFinalClassifier(myAssessment)


###################################################
### chunk number 12: Classify new Samples One
###################################################
#line 442 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
newSamplesFile <- paste(system.file(package="Rmagpie"),"/doc/vV_newSamples.txt",sep="")
res <- classifyNewSamples( myAssessment,newSamplesFile)


###################################################
### chunk number 13: Good prognois table1
###################################################
#line 447 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
library(xtable)
goodPrognosis <-names(res)[res=="goodPronosis"]
goodPrognosis


###################################################
### chunk number 14: poor prognois table1
###################################################
#line 453 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
poorPrognosis <-names(res)[res=="poorPronosis"]
poorPrognosis


###################################################
### chunk number 15: Classify new Samples two
###################################################
#line 459 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
newSamplesFile <- paste(system.file(package="Rmagpie"),"/doc/vV_newSamples.txt",sep="")
res <- classifyNewSamples( myAssessment,newSamplesFile,optionValue=1)


###################################################
### chunk number 16: Good prognois table2
###################################################
#line 464 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
goodPrognosis <-names(res)[res=="goodPronosis"]
goodPrognosis


###################################################
### chunk number 17: poor prognois table2
###################################################
#line 469 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
poorPrognosis <-names(res)[res=="poorPronosis"]


###################################################
### chunk number 18: Example One
###################################################
#line 549 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
# All the information on error rates for the repeated one-layer CV
getResults(myAssessment, 1, topic='errorRate')
# Cross-validated error rates for the repeated one-layer CV: Une value
# per size of subset
getResults(myAssessment, 1, topic='errorRate', errorType='cv')
# Cross-validated error rates for the repeated two-layer CV: Une value 
# only corresponding to the best error rate
getResults(myAssessment, 2, topic='errorRate', errorType='cv')


###################################################
### chunk number 19: Example 2
###################################################
#line 593 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
# Frequency of the genes selected among the folds and repeats 
# of the one-layer CV
res <- getResults(myAssessment, c(1,1), topic='genesSelected', genesType='frequ')
# Genes selected for the 3rd size of subset in the 2nd fold of the
# second repeat of one-layer external CV
getResults(myAssessment, c(1,2), topic='genesSelected', genesType='fold')[[3]][[2]]


###################################################
### chunk number 20: Example 3
###################################################
#line 609 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
# Best number of genes in one-layer CV
getResults(myAssessment, 1, topic='bestOptionValue')
# Best number of genes in the third repeat of one-layer CV
getResults(myAssessment, c(1,3), topic='bestOptionValue')
# Average (over the folds), best number of genes in the two-layer CV
getResults(myAssessment, 2, topic='bestOptionValue')
# Average (over the folds), best number of genes in the 
# third repeat of the two-layer CV
getResults(myAssessment, c(2,3), topic='bestOptionValue')


###################################################
### chunk number 21: Example 4
###################################################
#line 627 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
# Execution time to compute the repeated one-layer CV
getResults(myAssessment, 1, topic='executionTime')
# Execution time to compute the third repeat of the repeated one-layer CV
getResults(myAssessment, c(1,3), topic='executionTime')
# Execution time to compute the repeated two-layer CV
getResults(myAssessment, 2, topic='executionTime')
# Execution time to compute the second repeat of the repeated two-layer CV
getResults(myAssessment, c(2,2), topic='executionTime')


###################################################
### chunk number 22: PlotErrorSummary1
###################################################
#line 656 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
png("plotErrorsSummaryOneLayerCV.png")
plotErrorsSummaryOneLayerCV(myAssessment)
dev.off()


###################################################
### chunk number 23: PlotErrorSummaryRepeated
###################################################
#line 677 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
png("plotSummaryErrorRate.png")
plotErrorsRepeatedOneLayerCV(myAssessment)
dev.off()


###################################################
### chunk number 24: Two layer cross validation
###################################################
#line 696 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmplRctyb/R.INSTALL7d563ad/Rmagpie/inst/doc/Magpie_examples.Rnw"
png("twoLayerCrossValidation.png")
plotErrorsFoldTwoLayerCV(myAssessment)
dev.off()


