###################################################
### chunk number 1: prepare
###################################################
#line 63 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
options(length=60, stringsAsFactors=FALSE)
set.seed(123)
options(SweaveHooks=list(
   along=function() par(mar=c(2.5,4.2,4,1.5), font.lab=2),
   boxplot=function() par(mar=c(5,5,1,1), font.lab=4),
   dens=function() par(mar=c(4.1, 4.1, 0.1, 0.1), font.lab=2)))


###################################################
### chunk number 2: loadpackage
###################################################
#line 89 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
library("Ringo")


###################################################
### chunk number 3: locateData
###################################################
#line 121 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
exDir <- system.file("exData",package="Ringo")
list.files(exDir, pattern="pair.txt")
head(read.delim(file.path(exDir,"MOD_20551_PMT1_pair.txt"),
                skip=1))[,c(1,4:7,9)]


###################################################
### chunk number 4: exampleFilesTxt
###################################################
#line 135 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
read.delim(file.path(exDir,"example_targets.txt"), header=TRUE)


###################################################
### chunk number 5: spottypes
###################################################
#line 154 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
read.delim(file.path(exDir,"spottypes.txt"), header=TRUE)


###################################################
### chunk number 6: readNimblegen
###################################################
#line 162 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
exRG <- readNimblegen("example_targets.txt","spottypes.txt",path=exDir)


###################################################
### chunk number 7: showRG
###################################################
#line 170 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
head(exRG$R)
head(exRG$G)
head(exRG$genes)
exRG$targets


###################################################
### chunk number 8: loadProbeAnno
###################################################
#line 224 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
load(file.path(exDir,"exampleProbeAnno.rda"))
ls(exProbeAnno)
show(exProbeAnno)
head(exProbeAnno["9.start"])
head(exProbeAnno["9.end"])


###################################################
### chunk number 9: imageRG0 eval=FALSE
###################################################
## #line 256 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
## par(mar=c(0.01,0.01,0.01,0.01), bg="black")
## image(exRG, 1, channel="green", mycols=c("black","green4","springgreen"))


###################################################
### chunk number 10: imageRG
###################################################
#line 261 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
#jpeg("Ringo-imageRG.jpg", quality=100, height=400, width=360)
png("Ringo-imageRG.png", units="in", res=200, height=4, width=3.5)
par(mar=c(0.01,0.01,0.01,0.01), bg="black")
image(exRG, 1, channel="green", mycols=c("black","green4","springgreen"))
dev.off()


###################################################
### chunk number 11: plotDensities
###################################################
#line 286 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
plotDensities(exRG)


###################################################
### chunk number 12: showGFF
###################################################
#line 301 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
head(exGFF[,c("name","symbol","chr","strand","start","end")])


###################################################
### chunk number 13: autocorRG0
###################################################
#line 313 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
exAc <- autocor(exRG, probeAnno=exProbeAnno, chrom="9", lag.max=1000)
plot(exAc)


###################################################
### chunk number 14: preprocess eval=FALSE
###################################################
## #line 336 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
## exampleX <- preprocess(exRG)
## sampleNames(exampleX) <-
##  with(exRG$targets, paste(Cy5,"vs",Cy3,sep="_"))
## print(exampleX)


###################################################
### chunk number 15: loadExampleX
###################################################
#line 342 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
load(file.path(exDir,"exampleX.rda"))
print(exampleX)


###################################################
### chunk number 16: preprocessNG
###################################################
#line 351 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
exampleX.NG <- preprocess(exRG, method="nimblegen")
sampleNames(exampleX.NG) <- sampleNames(exampleX)


###################################################
### chunk number 17: comparePreprocessings
###################################################
#line 359 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
corPlot(cbind(exprs(exampleX),exprs(exampleX.NG)),
        grouping=c("VSN normalized","Tukey-biweight scaled"))


###################################################
### chunk number 18: chipAlongChrom
###################################################
#line 377 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
plot(exampleX, exProbeAnno, chrom="9", xlim=c(34318000,34321000),
     ylim=c(-2,4), gff=exGFF, colPal=c("skyblue", "darkblue"))


###################################################
### chunk number 19: smoothing
###################################################
#line 401 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
smoothX <- computeRunningMedians(exampleX, probeAnno=exProbeAnno,
modColumn = "Cy5", allChr = "9", winHalfSize = 400)
sampleNames(smoothX) <- paste(sampleNames(exampleX),"smoothed")


###################################################
### chunk number 20: smoothAlongChrom
###################################################
#line 407 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
combX <- combine(exampleX, smoothX)
plot(combX, exProbeAnno, chrom="9", xlim=c(34318000,34321000), 
     ylim=c(-2,4), gff=exGFF, colPal=c("skyblue", "steelblue"))


###################################################
### chunk number 21: setY0
###################################################
#line 489 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
(y0 <- apply(exprs(smoothX),2,upperBoundNull))


###################################################
### chunk number 22: histogramSmoothed
###################################################
#line 493 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
h1 <- hist(exprs(smoothX)[,1], n=50, xlim=c(-1.25,2.25), main=NA,
           xlab="Smoothed reporter intensities [log]")
abline(v=y0[1], col="red")


###################################################
### chunk number 23: cherFinding
###################################################
#line 512 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
chersX <- findChersOnSmoothed(smoothX, probeAnno=exProbeAnno, thresholds=y0,
   allChr="9", distCutOff=600, cellType="human")
chersX <- relateChers(chersX, exGFF)
chersXD <- as.data.frame.cherList(chersX)


###################################################
### chunk number 24: showChers
###################################################
#line 519 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
chersXD[order(chersXD$maxLevel, decreasing=TRUE),]


###################################################
### chunk number 25: plotCher
###################################################
#line 534 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
plot(chersX[[1]], smoothX, probeAnno=exProbeAnno, gff=exGFF,
     paletteName="Spectral")


###################################################
### chunk number 26: readAgilentData
###################################################
#line 574 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
agiDir <- system.file("agilentData", package="Ringo")
arrayfiles <- list.files(path=agiDir,
 pattern="H3K4Me3_Tc1Liver_sol1_mmChr17_part.txt")
RG <- read.maimages(arrayfiles, source="agilent", path=agiDir)


###################################################
### chunk number 27: readAgiTargets
###################################################
#line 582 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
at <- readTargets(file.path(agiDir,"targets.txt"))
RG$targets <- at


###################################################
### chunk number 28: showAgilentRG
###################################################
#line 587 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
show(RG)


###################################################
### chunk number 29: imageAgiRG0 eval=FALSE
###################################################
## #line 597 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
## par(mar=c(0.01,0.01,0.01,0.01), bg="black")
## image(RG, 1, channel="red", dim1="Col", dim2="Row",
##       mycols=c("sienna","darkred","orangered"))


###################################################
### chunk number 30: imageAgiRG
###################################################
#line 603 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
#jpeg("Ringo-imageAgiRG.jpg", quality=100, height=455, width=534)
png("Ringo-imageAgiRG.png", res=200, units="in", height=4.55, width=5.34)
par(mar=c(0.01,0.01,0.01,0.01), bg="black")
image(RG, 1, channel="red", dim1="Row", dim2="Col",
      mycols=c("sienna","darkred","orangered"))
dev.off()


###################################################
### chunk number 31: makeAgilentProbeAnno
###################################################
#line 636 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
pA <- extractProbeAnno(RG, "agilent", genome="mouse", 
   microarray="Agilent Tiling Chr17")


###################################################
### chunk number 32: agiLoadGenomeAnno
###################################################
#line 649 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
load(file=file.path(agiDir,"mm9chr17.RData"))


###################################################
### chunk number 33: preprocessAgilentData
###################################################
#line 656 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
X <- preprocess(RG[RG$genes$ControlType==0,], method="nimblegen", 
                idColumn="ProbeName")
sampleNames(X) <- X$SlideNumber


###################################################
### chunk number 34: agiProbeDistances
###################################################
#line 667 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
probeDists <- diff(pA["17.start"])
br <- c(0, 100, 200, 300, 500, 1000, 10000, max(probeDists))
table(cut(probeDists, br))


###################################################
### chunk number 35: agiSmoothing
###################################################
#line 673 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
smoothX <- computeRunningMedians(X, modColumn="Antibody",
              winHalfSize=500, min.probes=3, probeAnno=pA)
sampleNames(smoothX) <- paste(sampleNames(X),"smooth",sep=".")


###################################################
### chunk number 36: agiSmoothAlongChrom
###################################################
#line 682 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
combX <- combine(X, smoothX)
plot(combX, pA, chr="17", coord=33887000+c(0, 13000),
     gff=mm9chr17, maxInterDistance=450, paletteName="Paired")


###################################################
### chunk number 37: agiGetTwoThresholds
###################################################
#line 701 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
y0  <- upperBoundNull(exprs(smoothX))
y0G <- twoGaussiansNull(exprs(smoothX))


###################################################
### chunk number 38: agiShowHistogram
###################################################
#line 705 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
hist(exprs(smoothX), n=100, main=NA, 
     xlab="Smoothed expression level [log2]")
abline(v=y0, col="red", lwd=2)
abline(v=y0G, col="blue", lwd=2)
legend(x="topright", lwd=2, col=c("red","blue"),
       legend=c("Non-parametric symmetric Null", "Gaussian Null"))


###################################################
### chunk number 39: agiFindChers
###################################################
#line 718 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
chersX <- findChersOnSmoothed(smoothX, probeAnno=pA, threshold=y0G,
                              cellType="Tc1Liver")
chersX <- relateChers(chersX, gff=mm9chr17, upstream=5000)


###################################################
### chunk number 40: agiShowChers
###################################################
#line 726 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
chersXD <- as.data.frame(chersX)
head(chersXD[order(chersXD$maxLevel, decreasing=TRUE),])


###################################################
### chunk number 41: sessionInfo
###################################################
#line 759 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpZvTNo8/R.INSTALLeea1544/Ringo/inst/doc/Ringo.Rnw"
toLatex(sessionInfo(), locale=FALSE)


