###################################################
### chunk number 1: 
###################################################
#line 119 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpV8EGA1/R.INSTALLea388e/Rdisop/inst/doc/Rdisop.Rnw"
library(Rdisop)
molecule <- getMolecule("C2H5OH")
getFormula(molecule)
getMass(molecule)


###################################################
### chunk number 2: 
###################################################
#line 135 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpV8EGA1/R.INSTALLea388e/Rdisop/inst/doc/Rdisop.Rnw"
essentialElements <- initializeCHNOPSMgKCaFe()
chlorophyll <- getMolecule("C55H72MgN4O5H", z=1, 
  elements=essentialElements)
isotopes <- getIsotope(chlorophyll, seq(1,4))
isotopes


###################################################
### chunk number 3: isotopes
###################################################
#line 143 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpV8EGA1/R.INSTALLea388e/Rdisop/inst/doc/Rdisop.Rnw"
plot(t(isotopes), type="h", xlab="m/z", ylab="Intensity")


###################################################
### chunk number 4: 
###################################################
#line 165 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpV8EGA1/R.INSTALLea388e/Rdisop/inst/doc/Rdisop.Rnw"
molecules <- decomposeMass(46.042, ppm=20)
molecules


###################################################
### chunk number 5: 
###################################################
#line 180 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpV8EGA1/R.INSTALLea388e/Rdisop/inst/doc/Rdisop.Rnw"
length(decomposeMass(147.053))


###################################################
### chunk number 6: 
###################################################
#line 189 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpV8EGA1/R.INSTALLea388e/Rdisop/inst/doc/Rdisop.Rnw"
# glutamic acid (C5H9NO4)
masses <- c(147.053, 148.056)
intensities <- c(93, 5.8)

molecules <- decomposeIsotopes(masses, intensities)
cbind(getFormula(molecules), getScore(molecules), getValid(molecules))


###################################################
### chunk number 7: 
###################################################
#line 210 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpV8EGA1/R.INSTALLea388e/Rdisop/inst/doc/Rdisop.Rnw"
querymolecule <- subMolecules("C5H10NO4", "H")
getFormula(querymolecule)


