###################################################
### chunk number 1: g0
###################################################
#line 72 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  library(RCytoscape)
  g <- new ('graphNEL', edgemode='directed')
  g <- graph::addNode ('A', g)
  g <- graph::addNode ('B', g)
  g <- graph::addNode ('C', g)
  cw <- CytoscapeWindow ('vignette', graph=g)
  displayGraph (cw)



###################################################
### chunk number 2: g1
###################################################
#line 88 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  layout (cw, layout.name='grid')
  redraw (cw)


###################################################
### chunk number 3: g2
###################################################
#line 113 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  g <- cw@graph   # created above, in the section entitled 'A minimal example'
  g <- initNodeAttribute (graph=g,  attribute.name='moleculeType', attribute.type='char',
                          default.value='undefined')
  g <- initNodeAttribute (graph=g,  'lfc', 'numeric', 0.0)
  nodeData (g, 'A', 'moleculeType') <- 'kinase'
  nodeData (g, 'B', 'moleculeType') <- 'TF'
  nodeData (g, 'C', 'moleculeType') <- 'cytokine'
  nodeData (g, 'A', 'lfc') <- -1.2
  nodeData (g, 'B', 'lfc') <- 1.8
  nodeData (g, 'C', 'lfc') <- 3.2
  cw = setGraph (cw, g)
  displayGraph (cw)    # cw's graph is broadcast to Cytoscape
  redraw (cw)
  


###################################################
### chunk number 4: defaults
###################################################
#line 145 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  setDefaultNodeShape (cw, 'octagon')
  setDefaultNodeColor (cw, '#AAFF88')
  setDefaultNodeSize  (cw, 80)
  setDefaultNodeFontSize (cw, 40)
  redraw (cw)


###################################################
### chunk number 5: g3
###################################################
#line 155 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  getNodeShapes (cw)   # diamond, ellipse, trapezoid, triangle, etc.
  print (noa.names (getGraph (cw)))  # what data attributes are defined on the nodes?
  print (noa (getGraph (cw), 'moleculeType'))
  attribute.values <- c ('kinase',  'TF',       'cytokine')
  node.shapes      <- c ('diamond', 'triangle', 'rect')
  setNodeShapeRule (cw, node.attribute.name='moleculeType', attribute.values, node.shapes)
  redraw (cw)


###################################################
### chunk number 6: g4
###################################################
#line 180 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  setNodeColorRule (cw, 'lfc', c (-3.0, 0.0, 3.0), c ('#00AA00', '#00FF00', '#FFFFFF', '#FF0000', '#AA0000'))


###################################################
### chunk number 7: g41
###################################################
#line 185 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  setNodeColorRule (cw, 'lfc', c (-3.0, 0.0, 3.0), c ('#00FF00', '#FFFFFF', '#FF0000'))


###################################################
### chunk number 8: g5
###################################################
#line 193 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  control.points = c (-1.2, 2.0, 4.0)
  node.sizes     = c (10, 20, 50, 200, 205)
  setNodeSizeRule (cw, 'lfc', control.points, node.sizes, mode='interpolate')



###################################################
### chunk number 9: g6
###################################################
#line 200 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
 
  g <- cw@graph
  g <- initEdgeAttribute (graph=g,  attribute.name='edgeType', attribute.type='char', default.value='unspecified')

  g <- graph::addEdge ('A', 'B', g)
  g <- graph::addEdge ('B', 'C', g)
  g <- graph::addEdge ('C', 'A', g)

  edgeData (g, 'A', 'B', 'edgeType') <- 'phosphorylates'
  edgeData (g, 'B', 'C', 'edgeType') <- 'promotes'
  edgeData (g, 'C', 'A', 'edgeType') <- 'indirectly activates'
  cw@graph <- g
  displayGraph (cw)

  line.styles = c ('DOT', 'SOLID', 'SINEWAVE')
  edgeType.values = c ('phosphorylates', 'promotes', 'indirectly activates')
  setEdgeLineStyleRule (cw, 'edgeType', edgeType.values, line.styles)
  redraw (cw)

  arrow.styles = c ('Arrow', 'Delta', 'Circle')
  setEdgeTargetArrowRule (cw, 'edgeType', edgeType.values, arrow.styles)


###################################################
### chunk number 10: g7
###################################################
#line 226 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  hidePanel (cw, 'Data Panel')
  floatPanel (cw, 'D')
  dockPanel (cw, 'd')
  hidePanel (cw, 'Control Panel')
  floatPanel (cw, 'control')
  dockPanel (cw, 'c')


###################################################
### chunk number 11: g8
###################################################
#line 239 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  getSelectedNodes (cw)
    


###################################################
### chunk number 12: g9
###################################################
#line 246 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  sfn (cw)


###################################################
### chunk number 13: g10
###################################################
#line 252 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  nodes <- getSelectedNodes (cw)


###################################################
### chunk number 14: cleanup
###################################################
#line 256 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
RCytoscape:::.cleanup()


###################################################
### chunk number 15: position
###################################################
#line 264 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  cwe <- CytoscapeWindow ('test.setPosition', graph=RCytoscape::makeSimpleGraph ())
  displayGraph (cwe)
  layout (cwe, 'jgraph-spring')
  redraw (cwe)

  center.x <- 200
  center.y <- 200
  radius <- 200
  angles <- rep (seq (0, 360, 5), 3)  # sweep through full revoltion 3 times, 5 degrees at a time
    # move just the A node, swinging it around the 'center' at 200, 200.  
    # it would be nice to know more about the coordinate system than I now do, to 
    # query, for example, the  current position o any node
  for (angle in angles) {
    angle.in.radians <- angle * pi / 180
    x <- center.x + (radius * cos (angle.in.radians))
    y <- center.y + (radius * sin (angle.in.radians))
    setPosition (cwe, 'A', x, y)
    }



###################################################
### chunk number 16: moviePrep
###################################################
#line 292 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  g <- RCytoscape::makeSimpleGraph ()
  g <- initNodeAttribute (g, 'pval', 'numeric', 1.0)

  cwm <- CytoscapeWindow ('movie', graph =g)
  displayGraph (cwm)
  layout (cwm, 'jgraph-spring')
  redraw (cwm)


###################################################
### chunk number 17: movieRules
###################################################
#line 304 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"
  lfc.control.points <- c (-3.0, 0.0, 3.0)
  lfc.colors <- c ('#00AA00', '#00FF00', '#FFFFFF', '#FF0000', '#AA0000')
  setNodeColorRule (cwm, 'lfc', lfc.control.points, lfc.colors)

  pval.control.points <- c (0.1, 0.05, 0.01, 0.0001)
  pval.sizes          <- c (30, 50, 70, 100)
  setNodeSizeRule (cwm, 'pval', pval.control.points, pval.sizes)



###################################################
### chunk number 18: animate
###################################################
#line 315 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp3uzyJt/R.INSTALL518570e/RCytoscape/inst/doc/RCytoscape.Rnw"

  pval.timepoint.1 <- c (0.01, 0.3, 0.05)
  pval.timepoint.2 <- c (0.05, 0.01, 0.01)
  pval.timepoint.3 <- c (0.0001, 0.005, 0.1)

  lfc.timepoint.1 <- c (-1.0, 1.0, 0.0)
  lfc.timepoint.2 <- c (2.0, 3.0, -2.0)
  lfc.timepoint.3 <- c (2.5, 2.0, 0.0)

  for (i in 1:5) {  # run this loop 5 times
    sendNodeAttributesDirect (cwm, 'lfc',  'numeric', c ('A', 'B', 'C'), lfc.timepoint.1)
    sendNodeAttributesDirect (cwm, 'pval', 'numeric', c ('A', 'B', 'C'), pval.timepoint.1)
    redraw (cwm)
    msg (cwm, 'timepoint 1')
    system ('sleep 1')

    sendNodeAttributesDirect (cwm, 'lfc',  'numeric', c ('A', 'B', 'C'), lfc.timepoint.2)
    sendNodeAttributesDirect (cwm, 'pval', 'numeric', c ('A', 'B', 'C'), pval.timepoint.2)
    redraw (cwm)
    msg (cwm, 'timepoint 2')
    system ('sleep 1')

    sendNodeAttributesDirect (cwm, 'lfc',  'numeric', c ('A', 'B', 'C'), lfc.timepoint.3)
    sendNodeAttributesDirect (cwm, 'pval', 'numeric', c ('A', 'B', 'C'), pval.timepoint.3)
    redraw (cwm)
    msg (cwm, 'timepoint 3')
    system ('sleep 1')
    }



