###################################################
### chunk number 1: options
###################################################
#line 34 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
options(width=60)


###################################################
### chunk number 2: preliminaries
###################################################
#line 38 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
library("OTUbase")


###################################################
### chunk number 3: dirPath
###################################################
#line 82 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
dirPath <- system.file("extdata/Sogin_2006", package="OTUbase")


###################################################
### chunk number 4: readOTUset
###################################################
#line 90 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
soginOTU <- readOTUset(dirPath=dirPath, level="0.03", samplefile="sogin.groups", fastafile="sogin.fasta", otufile="sogin.unique.filter.fn.list", sampleADF="sample_metadata.txt")
soginOTU


###################################################
### chunk number 5: readTAXset
###################################################
#line 98 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
soginTAX <- readTAXset(dirPath=dirPath, fastafile='sogin.fasta', sampleADF='sample_metadata.txt', taxfile='sogin.unique.fix.tax', namefile='sogin.names', samplefile='sogin.groups')
soginTAX


###################################################
### chunk number 6: accessors
###################################################
#line 111 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
head(id(soginOTU))
head(sread(soginOTU))
head(sampleID(soginOTU))
head(sData(soginOTU))


###################################################
### chunk number 7: accessors
###################################################
#line 121 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
head(otuID(soginOTU))
head(tax(soginTAX))


###################################################
### chunk number 8: abundance
###################################################
#line 131 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
abundOTU <- abundance(soginOTU, weighted=F, collab='Site')
head(abundOTU)
abundTAX <- abundance(soginTAX, weighted=F, taxCol='genus', collab='Site')
head(abundTAX)


###################################################
### chunk number 9: RichnessEstimate
###################################################
#line 145 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
estrichOTU <- apply(abundOTU, 2, estimateR)
estrichOTU
estrichTAX <- apply(abundTAX, 2, estimateR)
estrichTAX


###################################################
### chunk number 10: clusterSamples
###################################################
#line 155 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
clusterSamples(soginOTU, distmethod='jaccard', clustermethod='complete', collab='Site')
clusterSamples(soginTAX, taxCol='genus', distmethod='jaccard', clustermethod='complete', collab='Site')


###################################################
### chunk number 11: subOTUset
###################################################
#line 167 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
soginReduced <- subOTUset(soginOTU, samples=c("137", "138", "53R", "55R"))
soginReduced


###################################################
### chunk number 12: sessionInfo
###################################################
#line 203 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpFMnqkw/R.INSTALLe23ef/OTUbase/inst/doc/Introduction_to_OTUbase.Rnw"
toLatex(sessionInfo())


