###################################################
### chunk number 1: load package and data
###################################################
#line 29 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
library(MBCB);
data(MBCBExpressionData);


###################################################
### chunk number 2: write sample data to files
###################################################
#line 36 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
write.table(expressionSignal, 'signal.txt', sep="\t");
write.table(negativeControl, 'negative.control.txt', sep="\t");


###################################################
### chunk number 3: read sample files in
###################################################
#line 42 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
data <- mbcb.parseFile('signal.txt', 'negative.control.txt');
signal <- data$sig;
negCon <- data$con;


###################################################
### chunk number 4: set BGcorrection method variables
###################################################
#line 62 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
nonparametric <- TRUE;
RMA<- TRUE;
MLE <- TRUE;
GMLE <- FALSE;
MCMC <- FALSE;


###################################################
### chunk number 5: BG correct sample data
###################################################
#line 70 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
 cor <- mbcb.correct(expressionSignal, negativeControl, nonparametric, RMA, MLE, MCMC, GMLE);


###################################################
### chunk number 6: mbcb.main with values set
###################################################
#line 77 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
mbcb.main(expressionSignal, negativeControl, nonparametric, RMA, MLE, MCMC, GMLE, "param-est", "bgCorrected");


###################################################
### chunk number 7: default mbcb.main run
###################################################
#line 81 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
mbcb.main(expressionSignal, negativeControl, paramEstFile="param-est", bgCorrectedFile="bgCorrected");


###################################################
### chunk number 8: plotcorrections
###################################################
#line 88 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
ylimits <- c(10,60000);

par(mfrow=c(2,2), mar=c(4,4,3,1))
boxplot(expressionSignal, log="y", ylim=ylimits, main="Raw Expression")
boxplot(cor$NP, log="y", ylim=ylimits, main="NP-corrected")
boxplot(cor$RMA, log="y", ylim=ylimits, main="RMA-corrected")
boxplot(cor$MLE, log="y", ylim=ylimits, main="MLE-corrected")


###################################################
### chunk number 9: MBCBnormalization
###################################################
#line 108 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
mbcb.main(expressionSignal, negativeControl, normMethod="quant");
quant_np <- read.csv("bgCorrected-NP.csv", row.names=1)
mbcb.main(expressionSignal, negativeControl, normMethod="median");
median_np <- read.csv("bgCorrected-NP.csv", row.names=1)


###################################################
### chunk number 10: normPlots
###################################################
#line 117 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
par(mfrow=c(2,2), mar=c(4,4,3,1))
boxplot(expressionSignal, log="y", main="Raw Expression")
boxplot(cor$NP, log="y", main="Non-normalized NP")
boxplot(median_np, log="y", main="Quantile Norm, NP-corrected")
boxplot(quant_np, log="y", main="Median Norm, NP-corrected")


###################################################
### chunk number 11: open GUI
###################################################
#line 128 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
mbcb.gui();


###################################################
### chunk number 12: sessionInfo
###################################################
#line 140 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpEntuDc/R.INSTALL4d8416aa/MBCB/inst/doc/MBCB.Rnw"
sessionInfo();


