###################################################
### chunk number 1: Prepare parameters
###################################################
#line 68 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
options(width=65)
set.seed(123)


###################################################
### chunk number 2: Load package
###################################################
#line 84 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
library("HTqPCR")


###################################################
### chunk number 3: Extract R code
###################################################
#line 94 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
all.R.commands <- system.file("doc", "HTqPCR.Rnw", package = "HTqPCR")
Stangle(all.R.commands)


###################################################
### chunk number 4: All functions
###################################################
#line 115 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
ls("package:HTqPCR")


###################################################
### chunk number 5: Load example data
###################################################
#line 154 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
data(qPCRraw)
data(qPCRpros)
class(qPCRraw)


###################################################
### chunk number 6: Example input files
###################################################
#line 180 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
path <- system.file("exData", package="HTqPCR")
head(read.delim(file.path(path, "files.txt")))


###################################################
### chunk number 7: Read raw data
###################################################
#line 189 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
files <- read.delim(file.path(path, "files.txt"))
raw <- readCtData(files=files$File, path=path)


###################################################
### chunk number 8: Show qPCRset data object
###################################################
#line 196 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
show(raw)


###################################################
### chunk number 9: Ct overview ex 1
###################################################
#line 214 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
g <- featureNames(raw)[1:10]
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, conf.int=TRUE, 
ylim=c(0,55))


###################################################
### chunk number 10: Ct overview ex 2
###################################################
#line 220 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, 
calibrator="Control")


###################################################
### chunk number 11: 
###################################################
#line 227 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
par(mfrow=c(2,1))
#line 214 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#228#"
g <- featureNames(raw)[1:10]
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, conf.int=TRUE, 
ylim=c(0,55))
#line 229 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 220 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#229#"
plotCtOverview(raw, genes=g, xlim=c(0,50), groups=files$Treatment, 
calibrator="Control")
#line 230 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 12: Ct card ex 1
###################################################
#line 241 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtCard(raw, col.range=c(10,35), well.size=2.6)


###################################################
### chunk number 13: Ct card ex 2
###################################################
#line 244 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
featureClass(raw) <- factor(c("Marker", "TF", "Kinase")[sample(c(1,1,2,2,1,3), 
384, replace=TRUE)])
plotCtCard(raw, plot="class", well.size=2.6)


###################################################
### chunk number 14: 
###################################################
#line 252 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 241 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#252#"
plotCtCard(raw, col.range=c(10,35), well.size=2.6)
#line 253 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 15: 
###################################################
#line 255 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 244 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#255#"
featureClass(raw) <- factor(c("Marker", "TF", "Kinase")[sample(c(1,1,2,2,1,3), 
384, replace=TRUE)])
plotCtCard(raw, plot="class", well.size=2.6)
#line 256 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 16: Set Ct categories
###################################################
#line 278 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
raw.cat <- setCategory(raw, groups=files$Treatment, quantile=0.8)


###################################################
### chunk number 17: Plot Ct categories ex 1
###################################################
#line 285 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtCategory(raw.cat)


###################################################
### chunk number 18: Plot Ct categories ex 2
###################################################
#line 288 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtCategory(raw.cat, stratify="class")


###################################################
### chunk number 19: 
###################################################
#line 294 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
par(mfrow=c(2,1))
#line 285 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#295#"
plotCtCategory(raw.cat)
#line 296 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 288 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#296#"
plotCtCategory(raw.cat, stratify="class")
#line 297 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 20: Plot Ct categories ex 3
###################################################
#line 306 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtCategory(raw.cat, by.feature=TRUE, cexRow=0.1)


###################################################
### chunk number 21: 
###################################################
#line 312 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 306 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#312#"
plotCtCategory(raw.cat, by.feature=TRUE, cexRow=0.1)
#line 313 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 22: Normalise data
###################################################
#line 348 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
q.norm <- normalizeCtData(raw.cat, norm="quantile")
sr.norm <- normalizeCtData(raw.cat, norm="scale.rank")
nr.norm <- normalizeCtData(raw.cat, norm="norm.rank")
d.norm <- normalizeCtData(raw.cat, norm="deltaCt", deltaCt.genes=c("Gene1", "Gene60"))


###################################################
### chunk number 23: Normalisation comparison
###################################################
#line 357 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plot(exprs(raw), exprs(q.norm), pch=20, main="Quantile normalisation", col=rep(brewer.pal(6, "Spectral"), each=384))


###################################################
### chunk number 24: 
###################################################
#line 363 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
col <- rep(brewer.pal(6, "Spectral"), each=384)
col2 <- brewer.pal(5, "Dark2")
par(mfrow=c(3,2), mar=c(2,2,2,2))
# All methods individually
plot(exprs(raw), exprs(q.norm), pch=20, main="Quantile normalisation", col=col)
plot(exprs(raw), exprs(sr.norm), pch=20, main="Rank invariant scaling", col=col)
plot(exprs(raw), exprs(nr.norm), pch=20, main="Rank invariant normalisation", col=col)
plot(exprs(raw), exprs(d.norm), pch=20, main="deltaCt normalisation", col=col)
# Just a single sample, across methods
plot(exprs(raw)[,1], exprs(q.norm)[,1], pch=20, col=col2[1], main="Comparison of methods for sample 1", ylim=c(-10,40))
points(exprs(raw)[,1], exprs(sr.norm)[,1], pch=20, col=col2[2])
points(exprs(raw)[,1], exprs(nr.norm)[,1], pch=20, col=col2[3])
points(exprs(raw)[,1], exprs(d.norm)[,1], pch=20, col=col2[4])
legend(8, 40, legend=c("Quantile", "Rank.invariant scaling", "Rank.invariant normalization", "deltaCt"), col=col2, lwd=2, bty="n")


###################################################
### chunk number 25: Subset data
###################################################
#line 392 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
nr.norm[1:10,]
nr.norm[,c(1,3,5)]


###################################################
### chunk number 26: Filter data 1
###################################################
#line 398 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
qFilt   <- filterCtData(nr.norm, remove.type="Endogenous Control")
qFilt   <- filterCtData(nr.norm, remove.name=c("Gene1", "Gene20", "Gene30"))
qFilt   <- filterCtData(nr.norm, remove.class="Kinase")
qFilt   <- filterCtData(nr.norm, remove.type=c("Endogenous Control"), remove.name=c("Gene1", "Gene20", "Gene30"))


###################################################
### chunk number 27: Filter data 2
###################################################
#line 407 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
qFilt   <- filterCtData(nr.norm, remove.category="Undetermined")
qFilt   <- filterCtData(nr.norm, remove.category="Undetermined", n.category=5)


###################################################
### chunk number 28: IQR plot
###################################################
#line 414 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
iqr.values <- apply(exprs(nr.norm), 1, IQR)
hist(iqr.values, n=20, main="", xlab="IQR across samples")
abline(v=1.5, col=2)


###################################################
### chunk number 29: Filter data 3
###################################################
#line 422 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
qFilt   <- filterCtData(nr.norm, remove.IQR=1.5)


###################################################
### chunk number 30: 
###################################################
#line 428 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 414 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#428#"
iqr.values <- apply(exprs(nr.norm), 1, IQR)
hist(iqr.values, n=20, main="", xlab="IQR across samples")
abline(v=1.5, col=2)
#line 429 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 31: Ct correlations
###################################################
#line 448 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtCor(raw, main="Ct correlation")


###################################################
### chunk number 32: 
###################################################
#line 454 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 448 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#454#"
plotCtCor(raw, main="Ct correlation")
#line 455 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 33: Summary of Ct values
###################################################
#line 466 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
summary(raw)


###################################################
### chunk number 34: Ct density
###################################################
#line 473 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtDensity(sr.norm)


###################################################
### chunk number 35: Ct histogram
###################################################
#line 476 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtHistogram(sr.norm)


###################################################
### chunk number 36: 
###################################################
#line 485 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(3,3,2,1))
#line 473 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#486#"
plotCtDensity(sr.norm)
#line 487 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 476 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#487#"
plotCtHistogram(sr.norm)
#line 488 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 37: 
###################################################
#line 499 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
par(mfrow=c(2,2), mar=c(2,2,2,1))
plotCtDensity(q.norm, main="quantile")
plotCtDensity(sr.norm, main="scale.rankinvariant")
plotCtDensity(nr.norm, main="norm.rankinvariant")
plotCtDensity(d.norm, main="deltaCt")


###################################################
### chunk number 38: Ct boxes
###################################################
#line 513 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtBoxes(sr.norm, stratify="class")


###################################################
### chunk number 39: 
###################################################
#line 519 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 513 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#519#"
plotCtBoxes(sr.norm, stratify="class")
#line 520 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 40: Ct scatter ex 1
###################################################
#line 531 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtScatter(sr.norm, cards=c(1,2), col="type", diag=TRUE)


###################################################
### chunk number 41: Ct scatter ex 2
###################################################
#line 534 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtScatter(sr.norm, cards=c(1,4), col="class", diag=TRUE)


###################################################
### chunk number 42: 
###################################################
#line 540 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(3,3,2,1))
#line 531 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#541#"
plotCtScatter(sr.norm, cards=c(1,2), col="type", diag=TRUE)
#line 542 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 534 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#542#"
plotCtScatter(sr.norm, cards=c(1,4), col="class", diag=TRUE)
#line 543 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 43: Ct pairs
###################################################
#line 555 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtPairs(sr.norm, col="type", diag=TRUE)


###################################################
### chunk number 44: 
###################################################
#line 561 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 555 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#561#"
plotCtPairs(sr.norm, col="type", diag=TRUE)
#line 562 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 45: Ct heatmap
###################################################
#line 575 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtHeatmap(raw, gene.names="", dist="euclidean")


###################################################
### chunk number 46: 
###################################################
#line 581 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 575 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#581#"
plotCtHeatmap(raw, gene.names="", dist="euclidean")
#line 582 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 47: Ct replicates
###################################################
#line 594 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtReps(qPCRraw, card=2, percent=20)


###################################################
### chunk number 48: 
###################################################
#line 600 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 594 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#600#"
plotCtReps(qPCRraw, card=2, percent=20)
#line 601 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 49: CV across samples
###################################################
#line 614 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCVBoxes(qPCRraw, stratify="class")
plotCVBoxes(qPCRraw, stratify="type")


###################################################
### chunk number 50: 
###################################################
#line 621 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(2,2,2,1))
plotCVBoxes(qPCRraw, stratify="class")
plotCVBoxes(qPCRraw, stratify="type")


###################################################
### chunk number 51: Cluster Ct
###################################################
#line 644 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
clusterCt(sr.norm, type="samples")


###################################################
### chunk number 52: 
###################################################
#line 650 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 644 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#650#"
clusterCt(sr.norm, type="samples")
#line 651 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 53: Plot subclusters
###################################################
#line 658 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
cluster.list <- clusterCt(sr.norm, type="genes", n.cluster=6, cex=0.5)


###################################################
### chunk number 54: Show subcluster
###################################################
#line 662 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
c6 <- cluster.list[[6]]
print(c6)
show(sr.norm[c6,])


###################################################
### chunk number 55: 
###################################################
#line 670 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 658 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#670#"
cluster.list <- clusterCt(sr.norm, type="genes", n.cluster=6, cex=0.5)
#line 671 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 56: Principal components analysis
###################################################
#line 682 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtPCA(qPCRraw)
plotCtPCA(qPCRraw, features=FALSE)


###################################################
### chunk number 57: 
###################################################
#line 689 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
par(mfrow=c(1,2), mar=c(2,2,2,1))
plotCtPCA(qPCRraw)
plotCtPCA(qPCRraw, features=FALSE)


###################################################
### chunk number 58: Object history
###################################################
#line 706 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
getCtHistory(sr.norm)
getCtHistory(qFilt)


###################################################
### chunk number 59: Perform standard t-test
###################################################
#line 726 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
qDE.ttest <- ttestCtData(sr.norm[,1:4], groups=files$Treatment[1:4], 
calibrator="Control")
head(qDE.ttest)


###################################################
### chunk number 60: Perform Mann-Whitney test
###################################################
#line 736 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
qDE.mwtest <- mannwhitneyCtData(sr.norm[,1:4], groups=files$Treatment[1:4], 
calibrator="Control")
head(qDE.mwtest)


###################################################
### chunk number 61: Perform limma test
###################################################
#line 746 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
# Preparing experiment design
design <- model.matrix(~0+files$Treatment)
colnames(design) <- c("Control", "LongStarve", "Starve")
print(design)
contrasts <- makeContrasts(LongStarve-Control, LongStarve-Starve, 
Starve-Control, (Starve+LongStarve)/2-Control, levels=design)
colnames(contrasts) <- c("LS-C", "LS-S", "S-C", "bothS-C")
print(contrasts)
# Reorder data to get the genes in consecutive rows
sr.norm2    <- sr.norm[order(featureNames(sr.norm)),] 
qDE.limma       <- limmaCtData(sr.norm2, design=design, contrasts=contrasts, 
ndups=2, spacing=1)


###################################################
### chunk number 62: limma test output
###################################################
#line 763 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
class(qDE.limma)
names(qDE.limma)
head(qDE.limma[["LS-C"]])


###################################################
### chunk number 63: limma summary output
###################################################
#line 771 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
qDE.limma[["Summary"]][21:30,]


###################################################
### chunk number 64: Relative quantification ex 1
###################################################
#line 786 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtRQ(qDE.ttest, genes=1:15)


###################################################
### chunk number 65: Relative quantification ex 2
###################################################
#line 790 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtRQ(qDE.limma, p.val=0.085, transform="log10", col="#9E0142")


###################################################
### chunk number 66: 
###################################################
#line 798 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 786 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#798#"
plotCtRQ(qDE.ttest, genes=1:15)
#line 799 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 67: 
###################################################
#line 808 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 790 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#808#"
plotCtRQ(qDE.limma, p.val=0.085, transform="log10", col="#9E0142")
#line 809 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 68: Significant Ct
###################################################
#line 820 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
plotCtSignificance(qDE.limma, q=sr.norm, 
groups=files$Treatment, target="LongStarve", 
calibrator="Control", genes=featureNames(sr.norm)[11:20], un.col="#3288BD", jitter=0.2)


###################################################
### chunk number 69: 
###################################################
#line 828 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 820 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#828#"
plotCtSignificance(qDE.limma, q=sr.norm, 
groups=files$Treatment, target="LongStarve", 
calibrator="Control", genes=featureNames(sr.norm)[11:20], un.col="#3288BD", jitter=0.2)
#line 829 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 70: Heatmap significant Ct
###################################################
#line 840 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
heatmapSig(qDE.limma, dist="euclidean")


###################################################
### chunk number 71: 
###################################################
#line 846 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
#line 840 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw#from line#846#"
heatmapSig(qDE.limma, dist="euclidean")
#line 847 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"


###################################################
### chunk number 72: Example SDS data
###################################################
#line 866 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
path <- system.file("exData", package="HTqPCR")
cat(paste(readLines(file.path(path, "SDS_sample.txt"), n=19), "\n"))


###################################################
### chunk number 73: Example SDS data 2
###################################################
#line 873 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
readLines(file.path(path, "SDS_sample.txt"), n=20)


###################################################
### chunk number 74: Multiple samples per card
###################################################
#line 900 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
# Example with 2  or 4 samples per 384 well card.
sample2.order	<- rep(c("subSampleA", "subSampleB"), each=192)
sample4.order	<- rep(c("subA", "subB", "subC", "subD"), each=96)
# Splitting the data into all individual samples
qPCRnew2 <- changeCtLayout(sr.norm, sample.order=sample2.order)
show(qPCRnew2)
qPCRnew4 <- changeCtLayout(sr.norm, sample.order=sample4.order)
show(qPCRnew4)


###################################################
### chunk number 75: Card history
###################################################
#line 913 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
getCtHistory(qPCRnew4)


###################################################
### chunk number 76: Combine qPCRset objects
###################################################
#line 931 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
q.comb	<- cbind(q.norm[,1:3], sr.norm[,4], nr.norm[,c(1,5,6)])
q.comb
q.comb2	<- rbind(q.norm, sr.norm[1:4,], nr.norm)
q.comb2


###################################################
### chunk number 77: Combined card history
###################################################
#line 940 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
getCtHistory(q.comb)


###################################################
### chunk number 78: Check HTqPCR news
###################################################
#line 952 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
news(Version>1.2, package="HTqPCR")


###################################################
### chunk number 79: sessionInfo
###################################################
#line 958 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpvnMjQa/R.INSTALL24ee2133/HTqPCR/inst/doc/HTqPCR.Rnw"
toLatex(sessionInfo())


