###################################################
### chunk number 1: Ropts
###################################################
#line 35 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
options(width=70)


###################################################
### chunk number 2: setup
###################################################
#line 88 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
library(HTSanalyzeR)
library(GSEABase)
library(cellHTS2)
library(org.Dm.eg.db)
library(GO.db)
library(KEGG.db)


###################################################
### chunk number 3: cellHTSRead
###################################################
#line 103 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
experimentName <- "KcViab"
dataPath <- system.file(experimentName, package = "cellHTS2")
x <- readPlateList("Platelist.txt", name = experimentName, 
path = dataPath,verbose=TRUE)


###################################################
### chunk number 4: cellHTSConfig
###################################################
#line 112 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
x <- configure(x, descripFile = "Description.txt", confFile = 
"Plateconf.txt", logFile = "Screenlog.txt", path = dataPath)


###################################################
### chunk number 5: cellHTSNorm
###################################################
#line 119 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
xn <- normalizePlates(x, scale = "multiplicative", log = FALSE, 
method = "median", varianceAdjust = "none")


###################################################
### chunk number 6: cellHTSNorm
###################################################
#line 126 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
xn <- annotate(xn, geneIDFile = "GeneIDs_Dm_HFA_1.1.txt", 
path = dataPath)


###################################################
### chunk number 7: cellHTSScore
###################################################
#line 133 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
xsc <- scoreReplicates(xn, sign = "-", method = "zscore")


###################################################
### chunk number 8: cellHTSSum
###################################################
#line 139 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
xsc <- summarizeReplicates(xsc, summary = "mean")	


###################################################
### chunk number 9: showXSC
###################################################
#line 143 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
xsc


###################################################
### chunk number 10: getDataFromCellHTS
###################################################
#line 160 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
data4enrich <- as.vector(Data(xsc))
names(data4enrich) <- fData(xsc)[, "GeneID"]
data4enrich <- data4enrich[which(!is.na(names(data4enrich)))]


###################################################
### chunk number 11: selectHits
###################################################
#line 168 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
hits <- names(data4enrich)[which(abs(data4enrich) > 2)]


###################################################
### chunk number 12: gscList
###################################################
#line 176 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
GO_MF <- GOGeneSets(species="Dm", ontologies=c("MF"))
GO_BP <- GOGeneSets(species="Dm", ontologies=c("BP"))
PW_KEGG <- KeggGeneSets(species="Dm")
ListGSC <- list(GO_MF=GO_MF, GO_BP=GO_BP, PW_KEGG=PW_KEGG)


###################################################
### chunk number 13: gscaInit
###################################################
#line 187 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
gsca <- new("GSCA", listOfGeneSetCollections=ListGSC, 
geneList=data4enrich, hits=hits)
gsca <- preprocess(gsca, species="Dm", initialIDs="FlybaseCG", 
keepMultipleMappings=TRUE, duplicateRemoverMethod="max", 
orderAbsValue=FALSE)


###################################################
### chunk number 14: gscaAnalyses
###################################################
#line 206 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
gsca<-analyze(gsca, para=list(pValueCutoff=0.05, pAdjustMethod
="BH", nPermutations=100, minGeneSetSize=180, exponent=1))


###################################################
### chunk number 15:  eval=FALSE
###################################################
## #line 215 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## library(snow)
## options(cluster=makeCluster(4, "SOCK"))


###################################################
### chunk number 16:  eval=FALSE
###################################################
## #line 222 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## if(is(getOption("cluster"), "cluster")) {
## 	stopCluster(getOption("cluster"))
## 	options(cluster=NULL)
## }


###################################################
### chunk number 17: gscaSum
###################################################
#line 234 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
summarize(gsca)


###################################################
### chunk number 18: selectSigGS
###################################################
#line 240 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
topGS_GO_MF <- getTopGeneSets(gsca, "GSEA.results", c("GO_MF", 
"PW_KEGG"), allSig=TRUE)


###################################################
### chunk number 19: printTopGSs
###################################################
#line 244 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
topGS_GO_MF


###################################################
### chunk number 20: viewGSEARandWalk
###################################################
#line 251 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
viewGSEA(gsca, "GO_MF", topGS_GO_MF[["GO_MF"]][1])


###################################################
### chunk number 21:  eval=FALSE
###################################################
## #line 264 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## plotGSEA(gsca, gscs=c("GO_BP","GO_MF","PW_KEGG"), 
## ntop=1, filepath=".")


###################################################
### chunk number 22: viewEnrichMap1_a
###################################################
#line 274 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
data("KcViab_GSCA")
viewEnrichMap(KcViab_GSCA, resultName="HyperGeo.results", 
gscs=c("PW_KEGG"), allSig=FALSE, ntop=30, gsNameType="id", 
displayEdgeLabel=FALSE, layout="layout.fruchterman.reingold")


###################################################
### chunk number 23: viewEnrichMap1_b
###################################################
#line 280 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
data("KcViab_GSCA")
viewEnrichMap(KcViab_GSCA, resultName="GSEA.results", 
gscs=c("PW_KEGG"), allSig=FALSE, ntop=30, gsNameType="id", 
displayEdgeLabel=FALSE, layout="layout.fruchterman.reingold")


###################################################
### chunk number 24: viewEnrichMap2_a
###################################################
#line 303 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
KcViab_GSCA<-appendGSTerms(KcViab_GSCA, goGSCs=c("GO_BP",
"GO_MF","GO_CC"), keggGSCs=c("PW_KEGG"))
viewEnrichMap(KcViab_GSCA, resultName="HyperGeo.results",
gscs=c("PW_KEGG"), allSig=FALSE, ntop=30, gsNameType="term", 
displayEdgeLabel=FALSE, layout="layout.fruchterman.reingold")


###################################################
### chunk number 25: viewEnrichMap2_b
###################################################
#line 310 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
KcViab_GSCA<-appendGSTerms(KcViab_GSCA, goGSCs=c("GO_BP",
"GO_MF","GO_CC"), keggGSCs=c("PW_KEGG"))
viewEnrichMap(KcViab_GSCA, resultName="GSEA.results", 
gscs=c("PW_KEGG"), allSig=FALSE, ntop=30, gsNameType="term", 
displayEdgeLabel=FALSE, layout="layout.fruchterman.reingold")


###################################################
### chunk number 26:  eval=FALSE
###################################################
## #line 336 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## plotEnrichMap(KcViab_GSCA, gscs=c("PW_KEGG"), allSig=TRUE, 
## ntop=NULL, gsNameType="id", displayEdgeLabel=FALSE,
## layout="layout.fruchterman.reingold", filepath=".", 
## filename="PW_KEGG.map.pdf",output="pdf", width=8, height=8)


###################################################
### chunk number 27: gscaReport eval=FALSE
###################################################
## #line 348 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## report(object=gsca, experimentName=experimentName, species="Dm", 
## allSig=TRUE, keggGSCs="PW_KEGG", goGSCs=c("GO_BP", "GO_MF"), 
## reportDir="HTSanalyzerGSCAReport")


###################################################
### chunk number 28: gscaReportStruct eval=FALSE
###################################################
## #line 356 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## print(dir("HTSanalyzerGSCAReport",recursive=TRUE))


###################################################
### chunk number 29: gscaSaveAndLoad eval=FALSE
###################################################
## #line 362 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## save(gsca, file="./gsca.RData")
## load(file="./gsca.RData")


###################################################
### chunk number 30: nwaGetPval
###################################################
#line 381 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
test.stats <- cellHTS2OutputStatTests(cellHTSobject=xn, 
annotationColumn="GeneID", alternative="two.sided", 
tests=c("T-test"))
library(BioNet)
pvalues <- aggrPvals(test.stats, order=2, plot=FALSE)


###################################################
### chunk number 31: nwaInit2 eval=FALSE
###################################################
## #line 393 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## data("Biogrid_DM_Interactome")
## nwa <- new("NWA", pvalues=pvalues, interactome=
## Biogrid_DM_Interactome, phenotypes=data4enrich)


###################################################
### chunk number 32: nwaInit
###################################################
#line 403 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
nwa <- new("NWA", pvalues=pvalues, phenotypes=data4enrich)
nwa <- preprocess(nwa, species="Dm", initialIDs="FlybaseCG", 
keepMultipleMappings=TRUE, duplicateRemoverMethod="max")


###################################################
### chunk number 33: getInteractome2 eval=FALSE
###################################################
## #line 411 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## nwa<-interactome(nwa, species="Dm", reportDir="HTSanalyzerReport",
## genetic=FALSE)


###################################################
### chunk number 34: getInteractome
###################################################
#line 416 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
data("Biogrid_DM_Mat")
nwa<-interactome(nwa, interactionMatrix=Biogrid_DM_Mat,
genetic=FALSE)


###################################################
### chunk number 35: showNWAGraph
###################################################
#line 422 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
nwa@interactome


###################################################
### chunk number 36: fitBUMplot
###################################################
#line 430 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
nwa<-analyze(nwa, fdr=0.001, species="Dm")


###################################################
### chunk number 37: nwaSum
###################################################
#line 448 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
summarize(nwa)


###################################################
### chunk number 38: viewSubNet
###################################################
#line 455 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
viewSubNet(nwa)


###################################################
### chunk number 39:  eval=FALSE
###################################################
## #line 471 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## plotSubNet(nwa, filepath=".", filename="subnetwork.png")


###################################################
### chunk number 40:  eval=FALSE
###################################################
## #line 479 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## report(object=nwa, experimentName=experimentName, species="Dm", 
## allSig=TRUE, keggGSCs="PW_KEGG", goGSCs=c("GO_BP", "GO_MF"), 
## reportDir="HTSanalyzerNWReport")


###################################################
### chunk number 41:  eval=FALSE
###################################################
## #line 487 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## reportAll(gsca=gsca, nwa=nwa, experimentName=experimentName, 
## species="Dm", allSig=TRUE, keggGSCs="PW_KEGG", goGSCs=
## c("GO_BP", "GO_MF"), reportDir="HTSanalyzerReport")


###################################################
### chunk number 42:  eval=FALSE
###################################################
## #line 495 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## save(nwa, file="./nwa.RData")
## load("./nwa.RData")


###################################################
### chunk number 43:  eval=FALSE
###################################################
## #line 506 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## data("KcViab_Norm")
## GO_CC<-GOGeneSets(species="Dm",ontologies=c("CC"))
## PW_KEGG<-KeggGeneSets(species="Dm")
## ListGSC<-list(GO_CC=GO_CC,PW_KEGG=PW_KEGG)


###################################################
### chunk number 44:  eval=FALSE
###################################################
## #line 515 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## HTSanalyzeR4cellHTS2(
## 	normCellHTSobject=KcViab_Norm,
## 	annotationColumn="GeneID",
## 	species="Dm",
## 	initialIDs="FlybaseCG",
## 	listOfGeneSetCollections=ListGSC,
## 	cutoffHitsEnrichment=2,
## 	minGeneSetSize=200,
## 	keggGSCs=c("PW_KEGG"),
## 	goGSCs=c("GO_CC"),
## 	reportDir="HTSanalyzerReport"
## ) 


###################################################
### chunk number 45:  eval=FALSE
###################################################
## #line 536 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## c2<-getGmt(con="c2.all.v2.5.symbols.gmt.txt",geneIdType=
## SymbolIdentifier(), collectionType=
## BroadCollection(category="c2"))


###################################################
### chunk number 46:  eval=FALSE
###################################################
## #line 543 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## c2entrez<-mapIdentifiers(c2, EntrezIdentifier('org.Hs.eg.db'))


###################################################
### chunk number 47:  eval=FALSE
###################################################
## #line 549 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
## collectionOfGeneSets<-geneIds(c2entrez)
## names(collectionOfGeneSets)<-names(c2entrez)


###################################################
### chunk number 48: sessionInfo
###################################################
#line 566 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgauKXv/R.INSTALL42ca34ed/HTSanalyzeR/inst/doc/HTSanalyzeR-Vignette.Rnw"
toLatex(sessionInfo())


