###################################################
### chunk number 1: loadGenomicFeatures
###################################################
#line 42 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
library("GenomicFeatures")


###################################################
### chunk number 2: supportedUCSCtables
###################################################
#line 83 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
supportedUCSCtables()[1:4, ]


###################################################
### chunk number 3: makeTranscriptDbFromUCSC eval=FALSE
###################################################
## #line 86 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
## mm9KG <- makeTranscriptDbFromUCSC(genome = "mm9", tablename = "knownGene")


###################################################
### chunk number 4: discoverChromNames
###################################################
#line 107 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
head(getChromInfoFromUCSC("hg19"))


###################################################
### chunk number 5: makeTranscriptDbFromBiomart eval=FALSE
###################################################
## #line 117 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
## mmusculusEnsembl <-
##    makeTranscriptDbFromBiomart(biomart = "ensembl",
##                               dataset = "mmusculus_gene_ensembl")


###################################################
### chunk number 6: saveFeatures 1 eval=FALSE
###################################################
## #line 152 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
## saveFeatures(mm9KG, file="fileName.sqlite")


###################################################
### chunk number 7: loadFeatures-1 eval=FALSE
###################################################
## #line 159 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
## mm9KG <- loadFeatures("fileName.sqlite")


###################################################
### chunk number 8: transcripts0
###################################################
#line 173 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
samplefile <- system.file("extdata", "UCSC_knownGene_sample.sqlite",
                          package="GenomicFeatures")
txdb <- loadFeatures(samplefile)
txdb


###################################################
### chunk number 9: transcripts1
###################################################
#line 193 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
GR <- transcripts(txdb)
GR[1:3]


###################################################
### chunk number 10: transcripts2
###################################################
#line 212 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
GR <- transcripts(txdb, vals <- list(tx_chrom = "chr1", tx_strand = "+"))
length(GR)
unique(strand(GR))


###################################################
### chunk number 11: transcriptsBy
###################################################
#line 232 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
GRList <- transcriptsBy(txdb, by = "gene")
length(GRList)
names(GRList)[10:13]
GRList[11:12]


###################################################
### chunk number 12: exonsBy
###################################################
#line 257 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
GRList <- exonsBy(txdb, by = "tx")
length(GRList)
names(GRList)[10:13]
GRList[[12]]


###################################################
### chunk number 13: internalID
###################################################
#line 288 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
tx_ids <- names(GRList)
vals <- list(tx_id=tx_ids)
txs <- transcripts(txdb, vals, columns = c("tx_id", "tx_name"))
head(values(txs))


###################################################
### chunk number 14: introns-UTRs
###################################################
#line 314 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
length(intronsByTranscript(txdb))
length(fiveUTRsByTranscript(txdb))
length(threeUTRsByTranscript(txdb))


###################################################
### chunk number 15: RNASEQData
###################################################
#line 328 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
gr <- GRanges(
    seqnames = rep("chr5",4),
    ranges = IRanges(start = c(244620, 244670, 245804, 247502),
                     end = c(244652, 244702, 245836, 247534)),
    strand = rep("+", 4))


###################################################
### chunk number 16: transcriptsByOverlaps
###################################################
#line 339 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
transcriptsByOverlaps(txdb, gr)


###################################################
### chunk number 17: exonsGroupedByTx
###################################################
#line 364 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
annotGr <- exonsBy(txdb, "tx")


###################################################
### chunk number 18: findOverlaps
###################################################
#line 372 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
OL <- findOverlaps(query = annotGr, subject = gr)


###################################################
### chunk number 19: getAnswers
###################################################
#line 384 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
tdata <- annotGr[unique(queryHits(OL)),]
tdata
length(tdata)


###################################################
### chunk number 20: SessionInfo
###################################################
#line 409 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpB4t6MC/R.INSTALL694b369e/GenomicFeatures/inst/doc/GenomicFeatures.Rnw"
sessionInfo()


