###################################################
### chunk number 1: preliminaries
###################################################
#line 34 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
library(GeneSelector)


###################################################
### chunk number 2: preliminaries
###################################################
#line 115 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
library(GeneSelector)


###################################################
### chunk number 3: 
###################################################
#line 120 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
data(toydata)
y <- as.numeric(toydata[1,])
x <- as.matrix(toydata[-1,])
dim(x)
table(y)


###################################################
### chunk number 4: 
###################################################
#line 131 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
par(mfrow=c(2,2))
for(i in 1:4) boxplot(x[i,]~y, main=paste("Gene", i))


###################################################
### chunk number 5: 
###################################################
#line 142 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
ordT <- RankingTstat(x, y, type="unpaired")


###################################################
### chunk number 6: 
###################################################
#line 149 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

getSlots("GeneRanking")
str(ordT)

show(ordT)
toplist(ordT)



###################################################
### chunk number 7: 
###################################################
#line 169 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
loo <- GenerateFoldMatrix(y = y, k=1)
show(loo)


###################################################
### chunk number 8: 
###################################################
#line 177 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

loor_ordT <- RepeatRanking(ordT, loo)



###################################################
### chunk number 9: 
###################################################
#line 185 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

ex1r_ordT <- RepeatRanking(ordT, loo, scheme = "labelexchange")



###################################################
### chunk number 10: 
###################################################
#line 195 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

boot <- GenerateBootMatrix(y = y, maxties=3, minclassize=5, repl=30)
show(boot)
boot_ordT <- RepeatRanking(ordT, boot)



###################################################
### chunk number 11: 
###################################################
#line 204 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
noise_ordT <- RepeatRanking(ordT, varlist=list(genewise=TRUE, factor=1/10))


###################################################
### chunk number 12: 
###################################################
#line 210 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
toplist(loor_ordT, show=FALSE)


###################################################
### chunk number 13: 
###################################################
#line 220 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
par(mfrow=c(2,2))
plot(loor_ordT, col="blue", pch=".", cex=2.5, main = "jackknife")
plot(ex1r_ordT, col="blue", pch=".", cex=2.5, main = "label exchange")
plot(boot_ordT, col="blue", pch=".", cex=2.5, main = "bootstrap")
plot(noise_ordT, frac=1/10, col="blue", pch=".", cex=2.5, main = "noise")


###################################################
### chunk number 14: 
###################################################
#line 321 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

stab_ex1r_ordT <- GetStabilityOverlap(ex1r_ordT, scheme = "original",
decay="linear")
show(stab_ex1r_ordT)



###################################################
### chunk number 15: 
###################################################
#line 333 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

summary(stab_ex1r_ordT, measure = "intersection", display = "all", position = 10)
summary(stab_ex1r_ordT, measure = "overlapscore", display = "all", position = 10)



###################################################
### chunk number 16: 
###################################################
#line 352 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
plot(stab_ex1r_ordT, frac = 1, mode = "mean")


###################################################
### chunk number 17: 
###################################################
#line 364 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

stab_loo_ordT <- GetStabilityDistance(ex1r_ordT, scheme = "original", measure
= "spearman", decay="linear")
show(stab_loo_ordT)
summary(stab_loo_ordT, display = "all")



###################################################
### chunk number 18: 
###################################################
#line 381 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
BaldiLongT <- RankingBaldiLong(x, y, type="unpaired")
FoxDimmicT <- RankingFoxDimmic(x, y, type="unpaired")
sam <- RankingSam(x, y, type="unpaired")
wilcox <- RankingWilcoxon(x, y, type="unpaired")
wilcoxeb <- RankingWilcEbam(x, y, type="unpaired")


###################################################
### chunk number 19: 
###################################################
#line 394 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"
Merged <- MergeMethods(list(ordT, BaldiLongT, FoxDimmicT, sam, wilcox, wilcoxeb))
HeatmapRankings(Merged, ind=1:40)



###################################################
### chunk number 20: 
###################################################
#line 410 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

AggMean <- AggregateSimple(Merged, measure = "mean")
AggMC <- AggregateMC(Merged, type = "MCT", maxrank = 100)
GeneSel <- GeneSelector(list(ordT, BaldiLongT, FoxDimmicT, sam, wilcox,
wilcoxeb), threshold="user", maxrank=50)
show(GeneSel)
sel <- sum(slot(GeneSel, "selected"))

cbind(mean = toplist(AggMean, top = sel, show = F), MC = toplist(AggMC, top
= sel, show = F), GeneSelector = toplist(GeneSel, top = sel, show = F)[,1])



###################################################
### chunk number 21: 
###################################################
#line 437 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp2Rn4Vz/R.INSTALL848533e/GeneSelector/inst/doc/GeneSelector.rnw"

plot(GeneSel, which = 1)
    


