###################################################
### chunk number 1: options
###################################################
#line 42 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
options(width=60)


###################################################
### chunk number 2: preliminaries
###################################################
#line 46 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
## FIXME: <adjMat> adjacency matrix -- color w. +/- 1
## FIXME: limma topTable --> GeneColorSet
## w. verbose=TRUE
library(GSEABase)
library(hgu95av2.db)
library(GO.db)


###################################################
### chunk number 3: GeneSet
###################################################
#line 65 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
data(sample.ExpressionSet) # from Biobase
egs <- GeneSet(sample.ExpressionSet[201:250,], setName="Sample")
egs


###################################################
### chunk number 4: geneIds
###################################################
#line 74 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
head(geneIds(egs))


###################################################
### chunk number 5: details
###################################################
#line 82 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
details(egs)


###################################################
### chunk number 6: 
###################################################
#line 91 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
  ## FIXME: GeneSet(AnnotationIdentifier("hgu95av2")) --> non-empty
  ## FIXME: GeneSet(AnnotationIdentifier("hgu95av2"),
  ## collectionType=GOCollection()) filters on GOCollection (or KEGG)


###################################################
### chunk number 7: GeneSet-methods
###################################################
#line 98 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
showMethods("GeneSet", inherited=FALSE)


###################################################
### chunk number 8: GeneIdentifierTypes
###################################################
#line 107 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
names(slot(getClass("GeneIdentifierType"), "subclasses"))


###################################################
### chunk number 9: mapIdentifiers
###################################################
#line 113 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
mapIdentifiers(egs, EntrezIdentifier())


###################################################
### chunk number 10: GeneSet_Identifiers
###################################################
#line 129 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
library(annotate)                       # getEG
eids <- unique(getEG(geneIds(egs), "hgu95av2"))
eids <- eids[!is.na(eids)]
GeneSet(EntrezIdentifier(), geneIds=as.character(eids))


###################################################
### chunk number 11: CollectionType
###################################################
#line 138 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
names(slot(getClass("CollectionType"), "subclasses"))


###################################################
### chunk number 12: GOCollection
###################################################
#line 146 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
GeneSet(GOCollection(c("GO:0005488", "GO:0019825"),
                     evidenceCode="IDA"),
        geneIdType=EntrezIdentifier("org.Hs.eg.db"),
        setName="Sample GO Collection")


###################################################
### chunk number 13: Broad
###################################################
#line 161 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
fl <- system.file("extdata", "Broad1.xml", package="GSEABase")
bgs <- GeneSet(BroadCollection(), urls=fl)
bgs


###################################################
### chunk number 14: Broad-to-annotation
###################################################
#line 174 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
bgs1 <- mapIdentifiers(bgs, AnnotationIdentifier("hgu95av2"))
bgs1


###################################################
### chunk number 15: subset
###################################################
#line 182 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
bgs[1:5]
bgs[c("GALNS", "LOC646365")]


###################################################
### chunk number 16: egs-bgs
###################################################
#line 190 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
egs & bgs1


###################################################
### chunk number 17: subset-ExpressionSet
###################################################
#line 200 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
sample.ExpressionSet[bgs,]


###################################################
### chunk number 18: GeneColorSet-setup
###################################################
#line 217 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
conn <- textConnection("
Entrez ID, Gene Symbol, Expression level, Phenotype response
##used to be MRP2
1244, ABCC2, Increase, Resistant
538, ATP7A, Increase, Resistant
540, ATP7B, Increase, Resistant
9961, MVP, Increase, Resistant
##the LRP below must be MVP
##LRP, Increase, Resistant - need to know which one
7507,XPA, Increase, Resistant
2067, ERCC1, Increase, Resistant
##TOP, Increase, Resistant  - need to know which one, notes say II
672, BRCA1, Increase, Resistant
3725, JUN, Increase, Resistant
#GCS, Increase, Resistant  - my notes say alpha-GCS - so which one?
##I only found gamma at PubMed as being related
2730, GCLM, Increase, Resistant")
tbl <- read.csv(conn, strip.white=TRUE,comment.char="#")
close(conn); unlink(conn)


###################################################
### chunk number 19: GeneColorSet-phenotype
###################################################
#line 238 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
tbl


###################################################
### chunk number 20: GeneColorSet-constructor
###################################################
#line 248 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
gcs <- GeneColorSet(EntrezIdentifier(),
                    setName="A color set",
                    geneIds=as.character(tbl$Entrez.ID),
                    phenotype="Cisplatin resistance",
                    geneColor=tbl$Expression.level,
                    phenotypeColor=tbl$Phenotype.response)
gcs


###################################################
### chunk number 21: GeneSetCollection
###################################################
#line 275 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
gsc <- GeneSetCollection(sample.ExpressionSet[201:250,], setType=GOCollection())
gsc
gsc[["GO:0005737"]]


###################################################
### chunk number 22: GeneSetCollection-GOCollection
###################################################
#line 286 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
GeneSetCollection(sample.ExpressionSet[201:300,],
                  setType=GOCollection(evidenceCode="IMP"))


###################################################
### chunk number 23: GeneSetCollection-BroadCollection
###################################################
#line 296 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
  ## FIXME: BroadCollection default to paste("c", 1:4, sep="")
  ## FIXME: GeneSetCollection(BroadCollection(), urls=fl); filters on bcCategory
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
gss <- getBroadSets(fl)
gss
names(gss)


###################################################
### chunk number 24: mapIds-GeneSetCollection
###################################################
#line 307 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpYkd1yW/R.INSTALL34185a58/GSEABase/inst/doc/GSEABase.Rnw"
gsc <- mapIdentifiers(gsc, EntrezIdentifier())
gsc
gsc[["GO:0005737"]]


