###################################################
### chunk number 1: objectCreation
###################################################
#line 64 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
library(Biostrings)
origMAlign <-
  read.DNAMultipleAlignment(filepath =
                            system.file("extdata",
                                        "msx2_mRNA.aln",
                                        package="Biostrings"),
                            format="clustal")

phylipMAlign <-
  read.AAMultipleAlignment(filepath =
                           system.file("extdata",
                                       "Phylip.txt",
                                       package="Biostrings"),
                           format="phylip")



###################################################
### chunk number 2: renameRows
###################################################
#line 84 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
rownames(origMAlign)
rownames(origMAlign) <- c("Human","Chimp","Cow","Mouse","Rat",
                          "Dog","Chicken","Salmon")
origMAlign


###################################################
### chunk number 3: detail eval=FALSE
###################################################
## #line 96 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
## detail(origMAlign)


###################################################
### chunk number 4: usingMasks
###################################################
#line 102 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
maskTest <- origMAlign
rowmask(maskTest) <- IRanges(start=1,end=3)
rowmask(maskTest)
maskTest

colmask(maskTest) <- IRanges(start=c(1,1000),end=c(500,2343))
colmask(maskTest)
maskTest


###################################################
### chunk number 5: nullOut masks
###################################################
#line 115 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
rowmask(maskTest) <- NULL
rowmask(maskTest)
colmask(maskTest) <- NULL
colmask(maskTest)
maskTest


###################################################
### chunk number 6: invertMask
###################################################
#line 128 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
rowmask(maskTest, invert=TRUE) <- IRanges(start=4,end=8)
rowmask(maskTest)
maskTest
colmask(maskTest, invert=TRUE) <- IRanges(start=501,end=999)
colmask(maskTest)
maskTest


###################################################
### chunk number 7: setup
###################################################
#line 152 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
## 1st lets null out the masks so we can have a fresh start.
colmask(maskTest) <- NULL
rowmask(maskTest) <- NULL


###################################################
### chunk number 8: appendMask
###################################################
#line 161 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
## Then we can demonstrate how the append argument works
rowmask(maskTest) <- IRanges(start=1,end=3)
maskTest

rowmask(maskTest,append="intersect") <- IRanges(start=2,end=5)
maskTest

rowmask(maskTest,append="replace") <- IRanges(start=5,end=8)
maskTest

rowmask(maskTest,append="replace",invert=TRUE) <- IRanges(start=5,end=8)
maskTest

rowmask(maskTest,append="union") <- IRanges(start=7,end=8)
maskTest


###################################################
### chunk number 9: maskMotif
###################################################
#line 184 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
tataMasked <- maskMotif(origMAlign, "TATA")
colmask(tataMasked)


###################################################
### chunk number 10: maskGaps
###################################################
#line 195 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
autoMasked <- maskGaps(origMAlign, min.fraction=0.5, min.block.width=4)
autoMasked


###################################################
### chunk number 11: asmatrix
###################################################
#line 207 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
full = as.matrix(origMAlign)
dim(full)
partial = as.matrix(autoMasked)
dim(partial)


###################################################
### chunk number 12: alphabetFreq
###################################################
#line 230 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
alphabetFrequency(autoMasked)


###################################################
### chunk number 13: consensus
###################################################
#line 238 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
consensusMatrix(autoMasked, baseOnly=TRUE)[, 84:90]
substr(consensusString(autoMasked),80,130)
consensusViews(autoMasked)


###################################################
### chunk number 14: cluster
###################################################
#line 250 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
sdist <- stringDist(as(origMAlign,"DNAStringSet"), method="hamming")
clust <- hclust(sdist, method = "single")
pdf(file="badTree.pdf")
plot(clust)
dev.off()


###################################################
### chunk number 15: cluster2
###################################################
#line 270 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
sdist <- stringDist(as(autoMasked,"DNAStringSet"), method="hamming")
clust <- hclust(sdist, method = "single")
pdf(file="goodTree.pdf")
plot(clust)
dev.off()
fourgroups <- cutree(clust, 4)
fourgroups


###################################################
### chunk number 16: fastaExample eval=FALSE
###################################################
## #line 304 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
## DNAStr = as(origMAlign, "DNAStringSet")
## write.XStringSet(DNAStr, file="myFile.fa")


###################################################
### chunk number 17: write.phylip eval=FALSE
###################################################
## #line 316 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
## write.phylip(phylipMAlign, filepath="myFile.txt")


###################################################
### chunk number 18: sessinfo
###################################################
#line 325 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpyN5wZO/R.INSTALL40b32b1/Biostrings/inst/doc/MultipleAlignments.Rnw"
sessionInfo()


