###################################################
### chunk number 1: init
###################################################
#line 54 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
options(width=65)


###################################################
### chunk number 2: install-pkg eval=FALSE
###################################################
## #line 98 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite(c("Biobase"))


###################################################
### chunk number 3: loadlib
###################################################
#line 113 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
library("Biobase")


###################################################
### chunk number 4: convert eval=FALSE
###################################################
## #line 140 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
## library(convert)
## as(object, "ExpressionSet")


###################################################
### chunk number 5: read-table-geneData
###################################################
#line 174 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
dataDirectory <- system.file("extdata", package="Biobase")
exprsFile <- file.path(dataDirectory, "exprsData.txt")
exprs <- as.matrix(read.table(exprsFile, header=TRUE, sep="\t",
                              row.names=1,
                              as.is=TRUE))


###################################################
### chunk number 6: exprsFile eval=FALSE
###################################################
## #line 185 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
## exprsFile <- "c:/path/to/exprsData.txt"


###################################################
### chunk number 7: geneData-peak
###################################################
#line 200 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
class(exprs)
dim(exprs)
colnames(exprs)
head(exprs[,1:5])


###################################################
### chunk number 8: ExpressionSet-basic
###################################################
#line 209 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
minimalSet <- new("ExpressionSet", exprs=exprs)


###################################################
### chunk number 9: pData
###################################################
#line 224 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
pDataFile <- file.path(dataDirectory, "pData.txt")
pData <- read.table(pDataFile,
                    row.names=1, header=TRUE, sep="\t")
dim(pData)
rownames(pData)
summary(pData)


###################################################
### chunk number 10: geneCovariate-geneData-name-match
###################################################
#line 237 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
all(rownames(pData)==colnames(exprs))


###################################################
### chunk number 11: colnames
###################################################
#line 263 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
names(pData)


###################################################
### chunk number 12: sapplyClasses
###################################################
#line 273 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
sapply(pData, class)


###################################################
### chunk number 13: simpleSubsetting
###################################################
#line 284 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
pData[c(15, 20), c("gender", "type")]
pData[pData$score>0.8,]


###################################################
### chunk number 14: metadata-create
###################################################
#line 295 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
metadata <- data.frame(labelDescription=
                       c("Patient gender", 
                         "Case/control status", 
                         "Tumor progress on XYZ scale"),
                       row.names=c("gender", "type", "score"))


###################################################
### chunk number 15: AnnotatedDataFrame
###################################################
#line 313 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
phenoData <- new("AnnotatedDataFrame", 
                 data=pData, varMetadata=metadata)
phenoData


###################################################
### chunk number 16: AnnotatedDataFrame-subset
###################################################
#line 324 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
head(pData(phenoData))
phenoData[c("A","Z"),"gender"]
pData(phenoData[phenoData$score>0.8,])


###################################################
### chunk number 17: annotation
###################################################
#line 351 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
annotation <- "hgu95av2"


###################################################
### chunk number 18: R.MIAME
###################################################
#line 368 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
experimentData <- new("MIAME",
  name="Pierre Fermat",
  lab="Francis Galton Lab",
  contact="pfermat@lab.not.exist",
  title="Smoking-Cancer Experiment",
  abstract="An example ExpressionSet",
  url="www.lab.not.exist",
  other=list(
    notes="Created from text files"
  ))


###################################################
### chunk number 19: ExpressionSetFinally
###################################################
#line 391 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
exampleSet <- new("ExpressionSet", 
                  exprs=exprs, 
                  phenoData=phenoData, 
                  experimentData=experimentData,
                  annotation="hgu95av2")


###################################################
### chunk number 20: ExpressionSet-minimal
###################################################
#line 407 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
minimalSet <- new("ExpressionSet", exprs=exprs)


###################################################
### chunk number 21: helpExpressionSet eval=FALSE
###################################################
## #line 420 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
## help("ExpressionSet-class")


###################################################
### chunk number 22: showExpressionSet
###################################################
#line 427 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
exampleSet


###################################################
### chunk number 23: usingDollar
###################################################
#line 437 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
exampleSet$gender[1:5]
exampleSet$gender[1:5] == "Female"


###################################################
### chunk number 24: featureNames
###################################################
#line 445 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
featureNames(exampleSet)[1:5]


###################################################
### chunk number 25: sampleNames
###################################################
#line 452 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
sampleNames(exampleSet)[1:5]
varLabels(exampleSet)


###################################################
### chunk number 26: exprs
###################################################
#line 460 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
mat <- exprs(exampleSet)
dim(mat)
adf <- phenoData(exampleSet)
adf


###################################################
### chunk number 27: first10
###################################################
#line 476 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
vv <- exampleSet[1:5, 1:3]
dim(vv)
featureNames(vv)
sampleNames(vv)


###################################################
### chunk number 28: males
###################################################
#line 484 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
males <- exampleSet[ , exampleSet$gender == "Male"]
males


###################################################
### chunk number 29: 
###################################################
#line 494 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp753tU5/R.INSTALL48d54977/Biobase/inst/doc/ExpressionSetIntroduction.Rnw"
toLatex(sessionInfo())


