/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class ClusterGenerator
implements Serializable {
    private boolean m_Debug = false;
    private Instances m_Format = null;
    private String m_RelationName = "";
    protected int m_NumAttributes = 2;
    protected int m_NumClusters = 4;
    private boolean m_ClassFlag = false;
    private int m_NumExamplesAct = 0;
    private PrintWriter m_Output = null;

    abstract Instances defineDataFormat() throws Exception;

    abstract Instance generateExample() throws Exception;

    abstract Instances generateExamples() throws Exception;

    abstract String generateStart() throws Exception;

    abstract String generateFinished() throws Exception;

    abstract boolean getSingleModeFlag() throws Exception;

    public void setClassFlag(boolean bl) {
        this.m_ClassFlag = bl;
    }

    public boolean getClassFlag() {
        boolean bl = this.m_ClassFlag;
        return this.m_ClassFlag;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setRelationName(String string) {
        if (string.length() == 0) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            String[] stringArray = this.getGenericOptions();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer = stringBuffer.append(stringArray[n].trim());
            }
            if (this instanceof OptionHandler) {
                stringArray = ((OptionHandler)((Object)this)).getOptions();
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer = stringBuffer.append(stringArray[n].trim());
                }
            }
            this.m_RelationName = stringBuffer.toString();
        } else {
            this.m_RelationName = string;
        }
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public void setNumClusters(int n) {
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public void setNumAttributes(int n) {
        this.m_NumAttributes = n;
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public void setNumExamplesAct(int n) {
        this.m_NumExamplesAct = n;
    }

    public int getNumExamplesAct() {
        return this.m_NumExamplesAct;
    }

    public void setOutput(PrintWriter printWriter) {
        this.m_Output = printWriter;
    }

    public PrintWriter getOutput() {
        return this.m_Output;
    }

    protected void setFormat(Instances instances) {
        this.m_Format = new Instances(instances, 0);
    }

    protected Instances getFormat() {
        Instances instances = new Instances(this.m_Format, 0);
        return instances;
    }

    protected String toStringFormat() {
        if (this.m_Format == null) {
            return "";
        }
        return this.m_Format.toString();
    }

    public static void makeData(ClusterGenerator clusterGenerator, String[] stringArray) throws Exception {
        boolean bl;
        int n;
        PrintWriter printWriter = null;
        try {
            ClusterGenerator.setOptions(clusterGenerator, stringArray);
        }
        catch (Exception exception) {
            String string = "";
            if (clusterGenerator instanceof OptionHandler) {
                string = clusterGenerator.listSpecificOptions(clusterGenerator);
            }
            String string2 = ClusterGenerator.listGenericOptions(clusterGenerator);
            throw new Exception('\n' + exception.getMessage() + string + string2);
        }
        clusterGenerator.setFormat(clusterGenerator.defineDataFormat());
        printWriter = clusterGenerator.getOutput();
        printWriter.println("% ");
        printWriter.print("% " + clusterGenerator.getClass().getName() + " ");
        String[] stringArray2 = clusterGenerator.getGenericOptions();
        for (n = 0; n < stringArray2.length; ++n) {
            printWriter.print(stringArray2[n] + " ");
        }
        stringArray2 = ((OptionHandler)((Object)clusterGenerator)).getOptions();
        for (n = 0; n < stringArray2.length; ++n) {
            printWriter.print(stringArray2[n] + " ");
        }
        printWriter.println("\n%");
        String string = clusterGenerator.generateStart();
        if (string.length() > 0) {
            printWriter.println(string);
        }
        if (bl = clusterGenerator.getSingleModeFlag()) {
            printWriter.println(clusterGenerator.toStringFormat());
            for (int i = 0; i < clusterGenerator.getNumExamplesAct(); ++i) {
                Instance instance = clusterGenerator.generateExample();
                printWriter.println(instance);
            }
        } else {
            Instances instances = clusterGenerator.generateExamples();
            printWriter.println(instances);
        }
        String string3 = clusterGenerator.generateFinished();
        if (string3.length() > 0) {
            printWriter.println(string3);
        }
        if (printWriter != null) {
            printWriter.close();
        }
    }

    private String listSpecificOptions(ClusterGenerator clusterGenerator) {
        String string = "";
        if (clusterGenerator instanceof OptionHandler) {
            string = string + "\nData Generator options:\n\n";
            Enumeration enumeration = ((OptionHandler)((Object)clusterGenerator)).listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                string = string + option.synopsis() + '\n' + option.description() + "\n";
            }
        }
        return string;
    }

    private static void setOptions(ClusterGenerator clusterGenerator, String[] stringArray) throws Exception {
        String string;
        boolean bl = false;
        String string2 = new String("");
        bl = Utils.getFlag('h', stringArray);
        if (Utils.getFlag('d', stringArray)) {
            clusterGenerator.setDebug(true);
        }
        String string3 = Utils.getOption('r', stringArray);
        string2 = Utils.getOption('o', stringArray);
        String string4 = Utils.getOption('k', stringArray);
        if (string4.length() != 0) {
            clusterGenerator.setNumClusters(Integer.parseInt(string4));
        }
        if (Utils.getFlag('c', stringArray)) {
            clusterGenerator.setClassFlag(true);
        }
        if ((string = Utils.getOption('a', stringArray)).length() != 0) {
            clusterGenerator.setNumAttributes(Integer.parseInt(string));
        }
        if (clusterGenerator instanceof OptionHandler) {
            ((OptionHandler)((Object)clusterGenerator)).setOptions(stringArray);
        }
        clusterGenerator.setRelationName(string3);
        Utils.checkForRemainingOptions(stringArray);
        if (bl) {
            throw new Exception("Help requested.\n");
        }
        PrintWriter printWriter = string2.length() != 0 ? new PrintWriter(new FileOutputStream(string2)) : new PrintWriter(System.out);
        clusterGenerator.setOutput(printWriter);
    }

    private static String listGenericOptions(ClusterGenerator clusterGenerator) {
        String string = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-r <relation name>\n\tThe name of the relation for the produced dataset.\n-a <number of attributes>\n\tThe number of attributes for the produced dataset.\n-k <number of clusters>\n\tThe number of clusters the dataset is produced in.\n-c \n\tThe class flag, if set, the cluster is listed in the class attribute.\n-o <file>\n\tThe name of the file output instances will be written to.\n\tIf not supplied the instances will be written to stdout.\n";
        return string;
    }

    private String[] getGenericOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        String string = this.getRelationName();
        if (string.length() > 0) {
            stringArray[n++] = "-r";
            stringArray[n++] = "" + this.getRelationName();
        }
        stringArray[n++] = "-a";
        stringArray[n++] = "" + this.getNumAttributes();
        stringArray[n++] = "-k";
        stringArray[n++] = "" + this.getNumClusters();
        if (this.getClassFlag()) {
            stringArray[n++] = "-c";
            stringArray[n++] = "";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }
}

