###################################################
### chunk number 1: bhcExample
###################################################
#line 42 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp1A2Gj8/R.INSTALL15675fe7/BHC/inst/doc/bhc.Rnw"
require(graphics)
require(BHC)
require(affydata)
require(gcrma)

data(Dilution)
ai        <- compute.affinities(cdfName(Dilution))
Dil.expr  <- gcrma(Dilution,affinity.info=ai,type="affinities")
testData  <- exprs(Dil.expr)
keep      <- sd(t(testData))>0
testData  <- testData[keep,]
testData  <- testData[1:100,]
geneNames <- row.names(testData)

nGenes         <- (dim(testData))[1];
nFeatures      <- (dim(testData))[2];
nFeatureValues <- 4
##NORMALISE EACH EXPERIMENT TO ZERO MEAN, UNIT VARIANCE
for (i in 1:nFeatures){
    newData      <- testData[,i]
    newData      <- (newData - mean(newData)) / sd(newData)
    testData[,i] <- newData
}
##DISCRETISE THE DATA ON A GENE-BY-GENE BASIS
##(defining the bins by equal quartiles)
for (i in 1:nGenes){
  newData      <- testData[i,]
  newData      <- rank(newData) - 1
  testData[i,] <- newData
}
##PERFORM THE CLUSTERING
hc <- bhc(testData, geneNames, nFeatureValues=nFeatureValues)


###################################################
### chunk number 2: fig1plot
###################################################
#line 78 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp1A2Gj8/R.INSTALL15675fe7/BHC/inst/doc/bhc.Rnw"
plot(hc, axes=FALSE)


###################################################
### chunk number 3: fig1
###################################################
#line 83 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp1A2Gj8/R.INSTALL15675fe7/BHC/inst/doc/bhc.Rnw"
#line 78 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp1A2Gj8/R.INSTALL15675fe7/BHC/inst/doc/bhc.Rnw#from line#83#"
plot(hc, axes=FALSE)
#line 84 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp1A2Gj8/R.INSTALL15675fe7/BHC/inst/doc/bhc.Rnw"


###################################################
### chunk number 4: bhcExample2
###################################################
#line 91 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp1A2Gj8/R.INSTALL15675fe7/BHC/inst/doc/bhc.Rnw"
##OUTPUT CLUSTER LABELS TO FILE
WriteOutClusterLabels(hc, "labels.txt", verbose=FALSE)


