#!/bin/sh

set -e  # Exit immediately if a simple command exits with a non-zero status

# We keep strict SNPs only (tagged "snp") i.e. we drop lines tagged as
#   "in-del", "mixed", "microsatellite", "named-locus" or "multinucleotide-polymorphism"
grep '| snp |' | \
  grep '| notwithdrawn |' | \
  # Filtering out SNPs with multiple reported locations on GRCh37
  grep -v '| CTG | assembly=GRCh37 |.*| CTG | assembly=GRCh37 |' | \
  grep "| CTG | assembly=GRCh37 | chr=$1 |" | \
  sed -r 's/\| notwithdrawn (\||\|.*\|) CTG \| assembly=GRCh37 \|/|/'

