###################################################
### chunk number 1: 
###################################################
library(spkTools)


###################################################
### chunk number 2: 
###################################################
data(affy)
object <- affy


###################################################
### chunk number 3: 
###################################################
fc=2
label="Affymetrix"
par(mar=c(3,2.5,2,0.5), cex=1.8)


###################################################
### chunk number 4: 
###################################################
spkSlopeOut <- spkSlope(object, label, pch="+")


###################################################
### chunk number 5: 
###################################################
spkDensity(object, spkSlopeOut, cuts=TRUE, label)


###################################################
### chunk number 6: 
###################################################
spkBoxOut <- spkBox(object, spkSlopeOut, fc)
plotSpkBox(spkBoxOut, fc, ylim=c(-1.5,2.5))
sbox <- summarySpkBox(spkBoxOut)


###################################################
### chunk number 7: 
###################################################
spkMA(object, spkSlopeOut, fc, label=label, ylim=c(-2.5,2.5))


###################################################
### chunk number 8: 
###################################################
vtmp <- spkVar(object)
sv <- as.numeric(vtmp[,2][-nrow(vtmp)])
bin <- c("Low", "Med", "High")
bins <- bin[spkSlopeOut$breaks[2,]]
tab1 <- data.frame(NominalConc=2^spkSlopeOut$breaks[1,],
                   AvgExp=round(spkSlopeOut$avgExp,1),
                   PropGenesBelow=round(spkSlopeOut$prop,2),
                   ALEStrata=bins,
                   SD=round(sv,2))
colnames(tab1) <- c("Nominal Conc",
                    "Avg Expression",
                    "Prop of Genes Below",
                    "ALE Strata",
                    "Std Dev")


###################################################
### chunk number 9: 
###################################################
library(xtable)
tab1x <- xtable(tab1)
print(tab1x)


###################################################
### chunk number 10: 
###################################################
AccuracySlope <- round(spkSlopeOut$slopes[-1], digits=2)
AccuracySD <- round(spkAccSD(object, spkSlopeOut), digits=2)
pot <- spkPot(object, spkSlopeOut, AccuracySlope, AccuracySD, 
              precisionQuantile=.995)
PrecisionSD <- round(sbox$madFC[1:3], digits=2)
PrecisionQuantile <- round(pot$quantiles, digits=2)
SNR <- round(AccuracySlope/PrecisionSD, digits=2)
POT <- round(pot$POTs, digits=2)
tab2 <- data.frame(AccuracySlope=AccuracySlope,
                   AccuracySD=AccuracySD,
                   PrecisionSD=PrecisionSD,
                   PrecisionQuantile=PrecisionQuantile,
                   SNR=SNR,
                   POT=POT)


###################################################
### chunk number 11: 
###################################################
tab2x <- xtable(tab2)
print(tab2x)


###################################################
### chunk number 12: 
###################################################
bals <- round(spkBal(object))
anv <- round(spkAnova(object), digits=2)
tab3 <- t(c(anv,bals))


###################################################
### chunk number 13: 
###################################################
tab3x <- xtable(tab3)
print(tab3x)


