###################################################
### chunk number 1: init
###################################################
options(width=50)


###################################################
### chunk number 2: 
###################################################
library(SRAdb)
sqlfile <- getSRAdbFile()


###################################################
### chunk number 3: 
###################################################
file.info('SRAmetadb.sqlite')


###################################################
### chunk number 4: 
###################################################
sra_con <- dbConnect(SQLite(),sqlfile)


###################################################
### chunk number 5: 
###################################################
sra_con <- dbConnect(SQLite(),'SRAmetadb.sqlite')


###################################################
### chunk number 6: 
###################################################
sra_tables <- dbListTables(sra_con)
sra_tables


###################################################
### chunk number 7: 
###################################################
dbListFields(sra_con,'study')


###################################################
### chunk number 8: 
###################################################
sqliteQuickSQL(sra_con,'PRAGMA TABLE_INFO(study)')


###################################################
### chunk number 9: j1
###################################################
rs <- dbGetQuery(sra_con,'select * from study limit 3')
rs[,1:5]


###################################################
### chunk number 10: j2
###################################################
rs <- dbGetQuery(sra_con,paste("select study_accession,study_title from study where",
                           "study_description like 'Transcriptome%'",sep=" "))
rs[1:3,]


###################################################
### chunk number 11: 
###################################################
getTableCounts <- function(tableName,conn) {
  sql <- sprintf("select count(*) from %s",tableName)
  return(dbGetQuery(conn,sql)[1,1])
}
do.call(rbind,sapply(sra_tables,getTableCounts,sra_con,simplify=FALSE))


###################################################
### chunk number 12: 
###################################################
conversion <- sraConvert(c('SRP001007','SRP000931'), sra_con= sra_con)
conversion[1:3,]


###################################################
### chunk number 13: 
###################################################
apply(conversion, 2, unique)


###################################################
### chunk number 14: 
###################################################
rs <- getSRA (search_terms ='breast cancer', out_types=c('run','study'),  sra_con=sra_con)
dim(rs)


###################################################
### chunk number 15: 
###################################################
rs <- getSRA (search_terms ='"breast cancer"', out_types=c('run','study'),  sra_con=sra_con)
dim(rs)


###################################################
### chunk number 16: 
###################################################
rs <- getSRA (search_terms ='MCF7 OR "MCF-7"', out_types=c('sample'), sra_con=sra_con) 
dim(rs)


###################################################
### chunk number 17: 
###################################################
rs <- getSRA (search_terms ='submission_center: GEO', out_types=c('submission'), sra_con=sra_con)  
dim(rs)


###################################################
### chunk number 18: 
###################################################
rs <- getSRA (search_terms ='Carcino*', out_types=c('study'), sra_con=sra_con)  
dim(rs)


###################################################
### chunk number 19:  eval=FALSE
###################################################
## listFastq ("SRA011804", sra_con=sra_con) 


###################################################
### chunk number 20:  eval=FALSE
###################################################
## rs <- getFastqInfo (in_acc=c("SRA011804"), sra_con=sra_con)
## rs[1:3,]


###################################################
### chunk number 21:  eval=FALSE
###################################################
## getFastq (in_acc=c("SRR000648","SRR000657"), sra_con=sra_con, destdir=getwd())


###################################################
### chunk number 22:  eval=FALSE
###################################################
## startIGV("mm")


###################################################
### chunk number 23:  eval=FALSE
###################################################
## exampleBams = file.path(system.file('extdata',package='SRAdb'),
##   dir(system.file('extdata',package='SRAdb'),pattern='bam$'))
## IGVgenome('hg18')
## IGVload(exampleBams)
## IGVgoto('chr1:1-1000')
## IGVsnapshot()


###################################################
### chunk number 24:  eval=FALSE
###################################################
## acc <- getSRA (search_terms ='colon cancer', out_types=c('sra'), sra_con=sra_con, acc_only=TRUE) 
## g <- entityGraph(acc)
## attrs <- getDefaultAttrs(list(node=list(fillcolor='lightblue', shape='ellipse')))
## plot(g, attrs= attrs)  


###################################################
### chunk number 25:  eval=FALSE
###################################################
## g <- sraGraph('colon cancer', sra_con)
## library(Rgraphviz)
## attrs <- getDefaultAttrs(list(node=list(fillcolor='lightblue', shape='ellipse')))
## plot(g, attrs=attrs)


###################################################
### chunk number 26: 
###################################################
toLatex(sessionInfo())


