###################################################
### chunk number 1: lib
###################################################
library(xtable)
library(RTCA)


###################################################
### chunk number 2: dataset
###################################################
ofile <-  system.file("extdata/testOutput.csv", package="RTCA")
pfile <- system.file("extdata/testOutputPhenoData.csv", package="RTCA")
pData <- read.csv(pfile, sep="\t", row.names="Well")
metaData <- data.frame(labelDescription=c(
                         "Rack number",
                         "siRNA catalogue number",
                         "siRNA gene symbol",
                         "siRNA EntrezGene ID",
                         "siRNA targeting accession"
                         ))
phData <- new("AnnotatedDataFrame", data=pData, varMetadata=metaData)
x <- parseRTCA(ofile, phenoData=phData)


###################################################
### chunk number 3: dims
###################################################
xTimePointNo <- dim(x)[[1]]
xSampleNo <- dim(x)[[2]]


###################################################
### chunk number 4: smoothTransform
###################################################
xSmooth <- smoothTransform(x)


###################################################
### chunk number 5: interpolationTranform
###################################################
xInter <- interpolationTransform(x)


###################################################
### chunk number 6: derivTransform
###################################################
xDeriv <- derivativeTransform(x)


###################################################
### chunk number 7: rgrTransform
###################################################
xRgr <- rgrTransform(x)


###################################################
### chunk number 8: sessionInfo
###################################################
toLatex(sessionInfo())


