###################################################
### chunk number 1: startchunk
###################################################
require(affy)
require(affydata)
data(Dilution)


###################################################
### chunk number 2: RPA.pointestimate
###################################################
require(RPA)
sets <- geneNames(Dilution)[1:2]
rpa.results <- RPA.pointestimate(Dilution, sets, cind = 1)


###################################################
### chunk number 3: rpa.res eval=FALSE
###################################################
## rpa.results <- RPA.pointestimate(Dilution, cind = 1)


###################################################
### chunk number 4: visu eval=FALSE
###################################################
## rpa.plot("1000_at", rpa.results)


###################################################
### chunk number 5: barplots
###################################################
rpa.plot("1000_at", rpa.results)


###################################################
### chunk number 6: noise
###################################################
noise <- get.probe.noise.estimates(rpa.results)


###################################################
### chunk number 7: Smat eval=FALSE
###################################################
## Smat <- RPA.preprocess(Dilution, cind = 1)


###################################################
### chunk number 8: pick eval=FALSE
###################################################
## S <- t(Smat$fcmat[Smat$set.inds[["1000_at"]], ])


###################################################
### chunk number 9: iter eval=FALSE
###################################################
## res <- RPA.iteration(S)


###################################################
### chunk number 10: setpriors
###################################################
alpha <- beta <- rep(1, 16)
probe.index <- 5
alpha[[probe.index]] <- 3
beta[[probe.index]] <- 1
priors <- set.priors(Dilution, set = "1000_at", alpha, beta)


###################################################
### chunk number 11: pe eval=FALSE
###################################################
## rpa.results <- RPA.pointestimate(Dilution, sets, priors = priors)


###################################################
### chunk number 12: rpa eval=FALSE
###################################################
## eset <- rpa(Dilution, cind = 1)


###################################################
### chunk number 13: details
###################################################
sessionInfo()


