###################################################
### chunk number 1: init
###################################################
options(width=65)


###################################################
### chunk number 2: install-pkg eval=FALSE
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite(c("Biobase"))


###################################################
### chunk number 3: loadlib
###################################################
library("Biobase")


###################################################
### chunk number 4: convert eval=FALSE
###################################################
## library(convert)
## as(object, "ExpressionSet")


###################################################
### chunk number 5: read-table-geneData
###################################################
dataDirectory <- system.file("extdata", package="Biobase")
exprsFile <- file.path(dataDirectory, "exprsData.txt")
exprs <- as.matrix(read.table(exprsFile, header=TRUE, sep="\t",
                              row.names=1,
                              as.is=TRUE))


###################################################
### chunk number 6: exprsFile eval=FALSE
###################################################
## exprsFile <- "c:/path/to/exprsData.txt"


###################################################
### chunk number 7: geneData-peak
###################################################
class(exprs)
dim(exprs)
colnames(exprs)
head(exprs[,1:5])


###################################################
### chunk number 8: ExpressionSet-basic
###################################################
minimalSet <- new("ExpressionSet", exprs=exprs)


###################################################
### chunk number 9: pData
###################################################
pDataFile <- file.path(dataDirectory, "pData.txt")
pData <- read.table(pDataFile,
                    row.names=1, header=TRUE, sep="\t")
dim(pData)
rownames(pData)
summary(pData)


###################################################
### chunk number 10: geneCovariate-geneData-name-match
###################################################
all(rownames(pData)==colnames(exprs))


###################################################
### chunk number 11: colnames
###################################################
names(pData)


###################################################
### chunk number 12: sapplyClasses
###################################################
sapply(pData, class)


###################################################
### chunk number 13: simpleSubsetting
###################################################
pData[c(15, 20), c("gender", "type")]
pData[pData$score>0.8,]


###################################################
### chunk number 14: metadata-create
###################################################
metadata <- data.frame(labelDescription=
                       c("Patient gender", 
                         "Case/control status", 
                         "Tumor progress on XYZ scale"),
                       row.names=c("gender", "type", "score"))


###################################################
### chunk number 15: AnnotatedDataFrame
###################################################
phenoData <- new("AnnotatedDataFrame", 
                 data=pData, varMetadata=metadata)
phenoData


###################################################
### chunk number 16: AnnotatedDataFrame-subset
###################################################
head(pData(phenoData))
phenoData[c("A","Z"),"gender"]
pData(phenoData[phenoData$score>0.8,])


###################################################
### chunk number 17: annotation
###################################################
annotation <- "hgu95av2"


###################################################
### chunk number 18: R.MIAME
###################################################
experimentData <- new("MIAME",
  name="Pierre Fermat",
  lab="Francis Galton Lab",
  contact="pfermat@lab.not.exist",
  title="Smoking-Cancer Experiment",
  abstract="An example ExpressionSet",
  url="www.lab.not.exist",
  other=list(
    notes="Created from text files"
  ))


###################################################
### chunk number 19: ExpressionSetFinally
###################################################
exampleSet <- new("ExpressionSet", 
                  exprs=exprs, 
                  phenoData=phenoData, 
                  experimentData=experimentData,
                  annotation="hgu95av2")


###################################################
### chunk number 20: ExpressionSet-minimal
###################################################
minimalSet <- new("ExpressionSet", exprs=exprs)


###################################################
### chunk number 21: helpExpressionSet eval=FALSE
###################################################
## help("ExpressionSet-class")


###################################################
### chunk number 22: showExpressionSet
###################################################
exampleSet


###################################################
### chunk number 23: usingDollar
###################################################
exampleSet$gender[1:5]
exampleSet$gender[1:5] == "Female"


###################################################
### chunk number 24: featureNames
###################################################
featureNames(exampleSet)[1:5]


###################################################
### chunk number 25: sampleNames
###################################################
sampleNames(exampleSet)[1:5]
varLabels(exampleSet)


###################################################
### chunk number 26: exprs
###################################################
mat <- exprs(exampleSet)
dim(mat)
adf <- phenoData(exampleSet)
adf


###################################################
### chunk number 27: first10
###################################################
vv <- exampleSet[1:5, 1:3]
dim(vv)
featureNames(vv)
sampleNames(vv)


###################################################
### chunk number 28: males
###################################################
males <- exampleSet[ , exampleSet$gender == "Male"]
males


###################################################
### chunk number 29: 
###################################################
toLatex(sessionInfo())


