###################################################
### chunk number 1:  eval=FALSE
###################################################
## apt.rma.sk <- read.delim("rma-bg.quant-norm.pm-only.med-polish.summary.txt", row.names=1, comment.char="", skip=52)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## apt.rma <- read.delim("rma-bg.quant-norm.pm-only.med-polish.summary.txt", row.names=1, comment.char="", skip=52)


###################################################
### chunk number 3:  eval=FALSE
###################################################
## plot(log2(apt.rma[,1] * apt.rma.sk[,1])/2, log2(apt.rma.sk[,1]/apt.rma[,1]), main="APT: RMA vs RMA-sketch", xlab="A = Log2(SketchRMA*RMA)", ylab="M = Log2(SketchRMA/RMA)",log="",ylim=c(-0.1,0.1))


###################################################
### chunk number 4:  eval=FALSE
###################################################
## data.rma <- rma(data.u133p2, "MixU133P2RMA", background="pmonly", normalize=TRUE)
## xps.rma  <- validData(data.rma)


###################################################
### chunk number 5:  eval=FALSE
###################################################
## plot(log2(apt.rma[,1] * xps.rma[,1])/2, log2(xps.rma[,1]/apt.rma[,1]), main="RMA: XPS vs APT", xlab="A = Log2(XPS*APT)", ylab="M = Log2(XPS/APT)",log="",ylim=c(-0.1,0.1))


###################################################
### chunk number 6:  eval=FALSE
###################################################
## affy.rma <- justRMA()
## affy.rma <- 2^exprs(affy.rma)


###################################################
### chunk number 7:  eval=FALSE
###################################################
## tmp <- cbind(xps.rma[,1],affy.rma[,1],apt.rma[,1])
## colnames(tmp) <- c("xps.rma","affy.rma","apt.rma")
## pairs(log2(tmp), labels=colnames(tmp))


###################################################
### chunk number 8:  eval=FALSE
###################################################
## apt.mas5 <- read.delim("mas5-bg.pm-mm.mas5-signal.summary.txt", row.names=1, comment.char="", skip=52)
## apt.mas5 <- apply(apt.mas5, 2, function(x){x*(500/mean(x, trim=0.02))})


###################################################
### chunk number 9:  eval=FALSE
###################################################
## data.mas5 <- mas5(data.u133p2,"MixU133P2MAS5All", normalize=TRUE, sc=500, update=TRUE)
## xps.mas5 <- validData(data.mas5)


###################################################
### chunk number 10:  eval=FALSE
###################################################
## affy <- ReadAffy()
## affy.mas5 <- mas5(affy, normalize=TRUE, sc=500)
## affy.mas5 <- exprs(affy.mas5)


###################################################
### chunk number 11:  eval=FALSE
###################################################
## call.mas5 <- mas5.call(data.u133p2,"MixU133P2Call")
## xps.pval  <- validData(call.mas5)


###################################################
### chunk number 12:  eval=FALSE
###################################################
## affy <- ReadAffy()
## affy.dc5  <- mas5calls(affy)
## affy.pval <- assayData(affy.dc5)[["se.exprs"]]


###################################################
### chunk number 13:  eval=FALSE
###################################################
## data.rma.tc <- rma(data.genome,"MixHuGeneRMAcore_tc", background="antigenomic",
##                    normalize=TRUE, option="transcript", exonlevel="core")
## xps.rma.tc  <- validData(data.rma.tc)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## tmp <- as.data.frame(rownames(xps.rma.tc))
## colnames(tmp) <- "probeset_id"
## write.table(tmp, "transcriptList.txt", quote=FALSE, row.names=FALSE)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## expr.mp.tc <- express(data.genome, "MixHuGeneMedPolcore_tc", summarize.method="medianpolish",
##               summarize.select="pmonly", summarize.option="transcript", summarize.logbase="log2",
##               summarize.params=c(10, 0.01, 1.0), exonlevel="core")
## xps.mp.tc <- validData(expr.mp.tc)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## data.rma.tc.bq99 <- rma(data.genome, "HuGeneMixRMAbgqu99mp9", background="antigenomic",
##                          normalize=TRUE, exonlevel=c(992316,992316,9216))
## xps.rma.tc.bq99 <- validData(data.rma.tc.bq99)


###################################################
### chunk number 17:  eval=FALSE
###################################################
## call.dabg.tc <- dabg.call(data.genome, "HuGeneMixDABGcore_tc", 
##                           option="transcript", exonlevel="core")
## xps.pval.tc <- validData(call.dabg.tc)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## writeLines(rownames(xps.rma.tc), "core.txt")
## metaProbesets(scheme.genome, "core.txt", "coreList.mps", "core")


###################################################
### chunk number 19:  eval=FALSE
###################################################
## data.rma.ps <- rma(data.genome, "MixHuGeneRMAcore_ps", background="antigenomic",
##                    normalize=TRUE, option="probeset", exonlevel="core")
## xps.rma.ps  <- validData(data.rma.ps)


###################################################
### chunk number 20:  eval=FALSE
###################################################
## tmp <- as.data.frame(rownames(xps.rma.ps))
## colnames(tmp) <- "probeset_id"
## write.table(tmp, "probesetList.txt", quote=FALSE, row.names=FALSE)


###################################################
### chunk number 21:  eval=FALSE
###################################################
## data.rma.ps.bq99 <- rma(data.genome,"HuGeneMixRMAbgqu99mp9_ps", background="antigenomic",
##                         normalize=TRUE, option="probeset", exonlevel=c(992316,992316,9216))
## xps.rma.ps.bq99 <- validData(data.rma.ps.bq99)


###################################################
### chunk number 22:  eval=FALSE
###################################################
## data.rma.ps <- rma(data.exon, "MixHuExonRMAcore_ps", background="antigenomic",
##                    normalize=TRUE, option="probeset", exonlevel="core")
## xps.rma.ps  <- validData(data.rma.ps)


###################################################
### chunk number 23:  eval=FALSE
###################################################
## tmp <- as.data.frame(rownames(xps.rma.ps))
## colnames(tmp) <- "probeset_id"
## write.table(tmp, "corePSList.txt", quote=FALSE, row.names=FALSE)


###################################################
### chunk number 24:  eval=FALSE
###################################################
## expr.mp.ps <- express(data.exon, "HuExonMedPolcorePS", summarize.method="medianpolish",
##               summarize.select="pmonly", summarize.option="probeset", summarize.logbase="log2",
##               summarize.params=c(10, 0.01, 1.0), exonlevel="core")
## xps.mp.ps <- validData(expr.mp.ps)


###################################################
### chunk number 25:  eval=FALSE
###################################################
## data.rma.ps.bq103 <- rma(data.exon, "HuExonMixRMAbgqu103mp9_ps", background="antigenomic",
##                      normalize=TRUE, option="probeset", exonlevel=c(1032124,1032124,9216))
## xps.rma.ps.bq103 <- validData(data.rma.ps.bq103)


###################################################
### chunk number 26:  eval=FALSE
###################################################
## data.rma.tc <- rma(data.exon, "MixHuExonRMAcore_tc", background="antigenomic",
##                    normalize=TRUE, option="transcript", exonlevel="core")
## xps.rma.tc  <- validData(data.rma.tc)


###################################################
### chunk number 27:  eval=FALSE
###################################################
## writeLines(rownames(xps.rma.tc), "core.txt")
## metaProbesets(scheme.exon, "core.txt", "coreList.mps", "core")


###################################################
### chunk number 28:  eval=FALSE
###################################################
## expr.mp.tc <- express(data.exon, "HuExonMedPolcore", summarize.method="medianpolish",
##               summarize.select="pmonly", summarize.option="transcript", summarize.logbase="log2",
##               summarize.params=c(10, 0.01, 1.0), exonlevel="core")
## xps.mp.tc <- validData(expr.mp.tc)


###################################################
### chunk number 29:  eval=FALSE
###################################################
## data.rma.tc.bq103 <- rma(data.exon, "HuExonMixRMAbgqu103mp9_tc", background="antigenomic",
##                      normalize=TRUE, option="transcript", exonlevel=c(1032124,1032124,9216))
## xps.rma.tc.bq103 <- validData(data.rma.tc.bq103)


###################################################
### chunk number 30:  eval=FALSE
###################################################
## call.dabg.ps <- dabg.call(data.exon, "HuExonDABGcorePS", option="probeset", exonlevel="core")
## xps.pval.ps <- validData(call.dabg.ps)


###################################################
### chunk number 31:  eval=FALSE
###################################################
## call.dabg.tc <- dabg.call(data.exon, "HuExonDABGcoreTC", option="transcript", exonlevel="core")
## xps.pval.tc <- pvalData(call.dabg.tc)


###################################################
### chunk number 32:  eval=FALSE
###################################################
## hx2hg <- read.delim("HuExVsHuGene_BestMatch.txt", row.names=3)
## up2hx <- read.delim("U133PlusVsHuEx_BestMatch.txt", row.names=3)
## up2hg <- read.delim("U133PlusVsHuGene_BestMatch.txt", row.names=3)


###################################################
### chunk number 33:  eval=FALSE
###################################################
## hx2hg <- uniqueframe(hx2hg)
## up2hx <- uniqueframe(up2hx)
## up2hg <- uniqueframe(up2hg)
## u2x   <- intersectframes(up2hx, up2hg)
## u2g   <- intersectframes(up2hg, up2hx)
## tmp   <- intersectrows(u2gx, xps.grma, 1, NULL)
## core  <- intersectrows(tmp,  xps.xrma, 2, NULL)


###################################################
### chunk number 34:  eval=FALSE
###################################################
## xpsu <- intersectrows(xps.urma, core, NULL, NULL)
## xpsg <- intersectrows(xps.grma, core, NULL, 1, -1)
## xpsx <- intersectrows(xps.xrma, core, NULL, 2, -1)
## aptg <- intersectrows(apt.grma, core, NULL, 1, -1)
## aptx <- intersectrows(apt.xrma, core, NULL, 2, -1)


###################################################
### chunk number 35:  eval=FALSE
###################################################
## tissue <- c(rep("Breast", 3), rep("Prostate", 3))
## design <- model.matrix(~factor(tissue)) 
## colnames(design) <- c("Breast","BreastvsProstate") 


###################################################
### chunk number 36:  eval=FALSE
###################################################
## tmp <- as.matrix(log2(xpsu))
## fit <- lmFit(tmp, design) 
## fit <- eBayes(fit) 
## xpsu.lm <- topTable(fit, coef=2, n=length(rownames(tmp)), adjust="BH")


###################################################
### chunk number 37:  eval=FALSE
###################################################
## apt.plier <- read.delim("plier-mm.summary.txt", row.names=1, comment.char="", skip=52)


###################################################
### chunk number 38:  eval=FALSE
###################################################
## plot(apt.plier[,1], apt.plier[,2], main="APT: PLIER", xlab="Breast_A", ylab="Breast_B",log="xy")


###################################################
### chunk number 39:  eval=FALSE
###################################################
## plot(log2(apt.plier[,1] * apt.plier[,2])/2, log2(apt.plier[,1]/apt.plier[,2]), main="APT: PLIER", xlab="A = Log2(BrA*BrB)", ylab="M = Log2(BrA/BrB)",log="")
## plot(log2(apt.rma[,1] * apt.rma[,2])/2, log2(apt.rma[,1]/apt.rma[,2]), main="APT: RMA", xlab="A = Log2(BrA*BrB)", ylab="M = Log2(BrA/BrB)",log="",ylim=c(-10,10))


