###################################################
### chunk number 1: 
###################################################
library(methVisual)
library(Biostrings)
library(gridBase) 
library(ca)
library(sqldf)
library(plotrix)
ps.options(pointsize=12)
options(width=60)


###################################################
### chunk number 2: 
###################################################
library(methVisual)  


###################################################
### chunk number 3: 
###################################################
dir.create(file.path(R.home(component="home"),"/BiqAnalyzer/"))


###################################################
### chunk number 4: 
###################################################
makeLocalExpDir(dataPath="/examples/BiqAnalyzer",localDir=file.path(R.home(component="home"),"/BiqAnalyzer/"))


###################################################
### chunk number 5: 
###################################################
methData <-MethDataInput(file.path(R.home(component="home"),"/BiqAnalyzer","/PathFileTab.txt"))


###################################################
### chunk number 6: 
###################################################
methData


###################################################
### chunk number 7: 
###################################################
refseq <- selectRefSeq(file.path(R.home(component="home"),"/BiqAnalyzer","/Master_Sequence.txt"))


###################################################
### chunk number 8: 
###################################################
QCdata <- MethylQC(refseq, methData,makeChange=TRUE,identity=80,conversion=90)


###################################################
### chunk number 9: 
###################################################
QCdata


###################################################
### chunk number 10: 
###################################################
methData <- MethAlignNW( refseq , QCdata)
methData


###################################################
### chunk number 11:  eval=FALSE
###################################################
## plotAbsMethyl(methData,real=TRUE)
## 


###################################################
### chunk number 12: Absolute-Methylation-Plot
###################################################
plotAbsMethyl(methData,real=TRUE)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## MethLollipops(methData)
## 


###################################################
### chunk number 14: Lollipops-plot
###################################################
MethLollipops(methData)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## file <- file.path(R.home(component="home"),"/BiqAnalyzer/","Cooccurrence.pdf")
## Cooccurrence(methData,file=file)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## 
## summery <- matrixSNP(methData)
## plotMatrixSNP(summery,methData)
## 


###################################################
### chunk number 17: Distant-cooccurrence
###################################################
summery <- matrixSNP(methData)
plotMatrixSNP(summery,methData)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## 
## methFisherTest(methData, c(2,3,5), c(1,4,6))
## 


###################################################
### chunk number 19: Fisher-Test
###################################################
methFisherTest(methData, c(2,3,5), c(1,4,6))


###################################################
### chunk number 20: 
###################################################
methWhitneyUTest(methData, c(2,3,5), c(1,4,6))


###################################################
### chunk number 21:  eval=FALSE
###################################################
## 
## heatMapMeth(methData)
## 


###################################################
### chunk number 22: Heat-Map
###################################################
heatMapMeth(methData)


###################################################
### chunk number 23:  eval=FALSE
###################################################
## 
## methCA(methData)
## 


###################################################
### chunk number 24: CA
###################################################
methCA(methData)


