###################################################
### chunk number 1: 
###################################################
library(maSigPro) # load maSigPro library


###################################################
### chunk number 2: 
###################################################
data(data.abiotic)
data(edesign.abiotic)


###################################################
### chunk number 3: 
###################################################
edesign.abiotic


###################################################
### chunk number 4: 
###################################################
design <- make.design.matrix(edesign.abiotic, degree = 2)


###################################################
### chunk number 5: 
###################################################
design$groups.vector


###################################################
### chunk number 6: 
###################################################
fit <- p.vector(data.abiotic, design, Q = 0.05, MT.adjust = "BH", min.obs = 20)



###################################################
### chunk number 7: 
###################################################
tstep <- T.fit(fit, step.method = "backward", alfa = 0.05)


###################################################
### chunk number 8: 
###################################################
sigs <- get.siggenes(tstep, rsq = 0.6, vars = "groups")
sigs$summary


###################################################
### chunk number 9: 
###################################################
names(sigs$sig.genes)
names(sigs$sig.genes$ColdvsControl)


###################################################
### chunk number 10: venn1
###################################################
suma2Venn(sigs$summary[, c(2:4)])



###################################################
### chunk number 11: 
###################################################
STMDE66 <- data.abiotic[rownames(data.abiotic)=="STMDE66", ]


###################################################
### chunk number 12: plotGroups1
###################################################
PlotGroups (STMDE66, edesign = edesign.abiotic)


###################################################
### chunk number 13: plotGroups2
###################################################
PlotGroups (STMDE66, edesign = edesign.abiotic, show.fit = T, dis = design$dis, groups.vector = design$groups.vector)


