###################################################
### chunk number 1: setup
###################################################
library(genomes)
data(lproks)
options(warn=-1, width=75, digits=2, scipen=3,  "prompt" = "R> ", "continue" = " ")
options(SweaveHooks=list(fig=function() par(mar=c(5,4.2,1,1))))


###################################################
### chunk number 2: esum
###################################################
sra <- term2summary("genomeprj sra[Filter] AND Bacteria[ORGN]")
sra


###################################################
### chunk number 3: eneigh
###################################################
data(virus)
subset(virus, name %like% 'Nipah*')
nipah<-term2neighbor('Nipah virus[orgn]')
nipah[,1:2]

buny<- term2neighbor("Bunyaviridae[ORGN]", derived=TRUE)
nrow(buny)
taxids<-unique(buny$taxid)
btax<- taxid2names(taxids)
genus<-gsub("(.*Bunyaviridae; )(\\w*)(.*)", "\\2", btax$lineage)
n<-match(buny$taxid, btax$taxid)
plotby(buny, genus[n], log='y', lbty='n', lcex=.7)



