###################################################
### chunk number 1: 
###################################################
library("annaffy")


###################################################
### chunk number 2: 
###################################################
data(aafExpr)
probeids <- featureNames(aafExpr)
symbols <- aafSymbol(probeids, "hgu95av2.db")
symbols[[54]]
symbols[55:57]


###################################################
### chunk number 3: 
###################################################
getText(symbols[54:57])


###################################################
### chunk number 4: 
###################################################
gos <- aafGO(probeids, "hgu95av2.db")
gos[[3]]


###################################################
### chunk number 5: 
###################################################
gos[[3]][[1]]@name


###################################################
### chunk number 6: 
###################################################
gbs <- aafGenBank(probeids, "hgu95av2.db")
getURL(gbs[[1]])


###################################################
### chunk number 7: 
###################################################
lls <- aafLocusLink(probeids, "hgu95av2.db") 
getURL(lls[[2]])


###################################################
### chunk number 8: 
###################################################
bands <- aafCytoband(probeids, "hgu95av2.db") 
getURL(bands[[2]])


###################################################
### chunk number 9: 
###################################################
pmids <- aafPubMed(probeids, "hgu95av2.db")
getURL(pmids[[2]])


###################################################
### chunk number 10: 
###################################################
getURL(gos[[1]])


###################################################
### chunk number 11: 
###################################################
getURL(gos[[1]][[4]])


###################################################
### chunk number 12: 
###################################################
paths <- aafPathway(probeids, "hgu95av2.db")
getURL(paths[[4]])


###################################################
### chunk number 13: 
###################################################
library(multtest)


###################################################
### chunk number 14: 
###################################################
class <- as.integer(pData(aafExpr)$covar1) - 1


###################################################
### chunk number 15: 
###################################################
teststat <- mt.teststat(exprs(aafExpr), class)
index <- order(abs(teststat), decreasing = TRUE)
probeids <- featureNames(aafExpr)[index]


###################################################
### chunk number 16: 
###################################################
aaf.handler()


###################################################
### chunk number 17: 
###################################################
anncols <- aaf.handler()[c(1:3,8:9,11:13)]


###################################################
### chunk number 18: 
###################################################
anntable <- aafTableAnn(probeids[1:50], "hgu95av2.db", anncols)


###################################################
### chunk number 19: 
###################################################
saveHTML(anntable, "example1.html", title = "Example Table without Data")


###################################################
### chunk number 20: 
###################################################
testtable <- aafTable("t-statistic" = teststat[index[1:50]], signed = TRUE)
table <- merge(anntable, testtable)


###################################################
### chunk number 21: 
###################################################
exprtable <- aafTableInt(aafExpr, probeids = probeids[1:50])
table <- merge(table, exprtable)
saveHTML(table, "example2.html", title = "Example Table with Data")


###################################################
### chunk number 22: 
###################################################
saveText(table, "example2.txt")


###################################################
### chunk number 23: 
###################################################
library(hgu95av2.db)
probeids <- ls(hgu95av2SYMBOL)
gos <- aafGO(probeids[1:2], "hgu95av2.db")
getText(gos)


###################################################
### chunk number 24: 
###################################################
kinases <- aafSearchText("hgu95av2.db", "Description", "kinase")
kinases[1:5]
print(length(kinases))


###################################################
### chunk number 25: 
###################################################
probes <- aafSearchText("hgu95av2.db", c("Description", "Pathway"),
                        c("ribosome", "polymerase"))
print(length(probes))


###################################################
### chunk number 26: 
###################################################
probes <- aafSearchText("hgu95av2.db", "Description",
                        c("DNA", "polymerase"), logic = "AND")
print(length(probes))


###################################################
### chunk number 27: 
###################################################
gbs <- c("AF035121", "AL021546", "AJ006123", "AL080082", "AI289489")
aafSearchText("hgu95av2.db", "GenBank", gbs)


###################################################
### chunk number 28: 
###################################################
aafSearchGO("hgu95av2.db", c("GO:0000002", "GO:0000008"))
aafSearchGO("hgu95av2.db", c("2", "8"))
aafSearchGO("hgu95av2.db", c(2, 8))


