###################################################
### chunk number 1: 
###################################################
library(MassArray)


###################################################
### chunk number 2: 
###################################################
data.path <- system.file("extdata", package="MassArray")
initial.path <- getwd()


###################################################
### chunk number 3: fig1
###################################################
results <- ampliconPrediction("AAAATTTTCCCCTCTGCGTGAGAGAGTTGTCCGACAAAA")
results


###################################################
### chunk number 4: fig2
###################################################
ampliconPrediction("AAAA>TTTTCCCCTCTGCGTGAGAGAGTTGTC(CG)AC<AAAA")


###################################################
### chunk number 5: fig3
###################################################
ampliconPrediction("AAAATTTTCCCCTCTGCGTGAGAGAGTTGTC(CG)ACTTCCCCTCTGCGTGAGAGAGTTGTCCGACAAAA")


###################################################
### chunk number 6: fig4
###################################################
ampliconPrediction("CCTGTCCAGGGGCACTCCATATTTTCCTACCTGTCCCTCTTTGCTTGTAAAAACAAATTAAACAGGGATCCCAGCAACTTCG")


###################################################
### chunk number 7: 
###################################################
setwd(data.path)


###################################################
### chunk number 8: 
###################################################
sequence <- "CCAGGTCCAAAGGTTCAGACCAGTCTGAA>CCTGTCCAGGGGCACTCCATATTTTCC"
sequence <- paste(sequence, "TACCTGTCCCTCTTTGCTTGTAAAAACAAATTAAACAGGGA", sep="")
sequence <- paste(sequence, "TCCCAGCAACTTCGGGGCATGTGTGTAACTGTGCAAGGAGC", sep="")
sequence <- paste(sequence, "GCGAAGCCCAGAGCATCGCCCTAGAGTTCGGGCCGCAGCTG", sep="")
sequence <- paste(sequence, "CAGAGGCACATCTGGAAAAGGGGGAGGGGTCGAAGCGGAGG", sep="")
sequence <- paste(sequence, "GGACAAGAAGCCCCCAAACGACTAGCTTCTGGGTGCAGAGT", sep="")
sequence <- paste(sequence, "CTGTGTCAC(CG)GGGGTTAGTTACCTGTCCTACGTTGATG", sep="")
sequence <- paste(sequence, "AATCCGTACTTGCTGGCTATGCGGTCTGCCTCCGCGAATCC", sep="")
sequence <- paste(sequence, "GC(CG)GC<GATCTTCACTGCCCAGTGGTTGGTGTA", sep="")
data <- new("MassArrayData", sequence, file="Example.txt")


###################################################
### chunk number 9: 
###################################################
setwd(initial.path)


###################################################
### chunk number 10: fig5
###################################################
plot(data, collapse=FALSE, bars=FALSE, scale=FALSE)


###################################################
### chunk number 11: fig6
###################################################
plot(data, collapse=TRUE, bars=TRUE, scale=FALSE)


###################################################
### chunk number 12: fig7
###################################################
plot(data, collapse=TRUE, bars=FALSE, scale=TRUE)


###################################################
### chunk number 13: fig8
###################################################
SNP.results <- evaluateSNPs(data)


###################################################
### chunk number 14: 
###################################################
length(SNP.results)
SNP.results[[2]]


