###

test_transcripts <- function()
{
    txdb <- loadFeatures(system.file("extdata", "UCSC_knownGene_sample.sqlite", 
                                     package="GenomicFeatures"))
    seqlengths <- seqlengths(txdb)
    seqlevels <- names(seqlengths)

    checkException(transcripts(data.frame()), silent = TRUE)
    checkException(transcripts(txdb, vals = list("bad" = 1:10)), silent = TRUE)
    checkException(transcripts(txdb, columns = "bad"), silent = TRUE)

    checkIdentical(transcripts(txdb, list("tx_id" = 3)),
                   GRanges(seqnames = factor("chr1", levels = seqlevels),
                           ranges = IRanges(start=4269, end=6628),
                           strand = strand("-"),
                           tx_id = 3L,
                           tx_name = "uc009vis.1",
                           seqlengths = seqlengths))

    vals <- list(tx_chrom = c("chr1", "chr5"), tx_strand = "-")
    wantRanges <- IRanges(start = c(4269, 257875),
                          end   = c(6628, 271297))
    want <- GRanges(seqnames = factor(c("chr1", "chr5"), levels = seqlevels),
                    ranges = wantRanges,
                    strand  = strand(rep("-", 2)),
                    tx_id   = c(3L, 15L),
                    tx_name = c("uc009vis.1", "uc003jam.1"),
                    exon_id = IntegerList("3"=c(8,7,6,5), "15"=c(79,78,77)),
                    seqlengths = seqlengths)
    elementMetadata(want)[["exon_id"]] <-
      IntegerList("3"=c(8,7,6,5), "15"=c(79,78,77))
    checkIdentical(want,
                   transcripts(txdb, vals, columns = c("tx_id","tx_name","exon_id")))

    got <- transcripts(txdb, vals=list(gene_id=c("3081", "9501")),
                             columns=c("tx_id", "tx_name", "gene_id"))

    tx_id_col <- c(58:60, 83:84)
    gene_id_col <- CharacterList(as.list(c(rep.int("9501", 3),
                                           rep.int("3081", 2))))
    names(gene_id_col) <- tx_id_col
    want <- GRanges(seqnames = factor(c(rep.int("chr17", 3),
                                        rep.int("chr3_random", 2)),
                                      levels = seqlevels),
                    ranges = IRanges(
                               start=c(rep.int(62294, 3), 18988, 49418),
                               end=c(177378, 202576, 202576, 73308, 73308)),
                    strand = strand(c("-", "-", "-", "+", "+")),
                    tx_id = tx_id_col,
                    tx_name = c("uc002frd.1", "uc002fre.1", "uc002frf.1",
                                "uc003fzi.1", "uc003fzj.1"),
                    gene_id = gene_id_col,
                    seqlengths = seqlengths)
    checkIdentical(got, want)
}

test_exons <- function()
{
    txdb <- loadFeatures(system.file("extdata", "UCSC_knownGene_sample.sqlite", 
                                      package="GenomicFeatures"))
    seqlengths <- seqlengths(txdb)
    seqlevels <- names(seqlengths)

    checkException(exons(data.frame()), silent = TRUE)
    checkException(exons(txdb, vals = list("bad" = 1:10)), silent = TRUE)

    checkIdentical(exons(txdb, list("exon_id" = 1)),
                   GRanges(seqnames = factor("chr1", levels = seqlevels),
                           ranges = IRanges(start=1116, end=2090),
                           strand = strand("+"),
                           exon_id = 1L,
                           seqlengths = seqlengths))

    wantRanges <- IRanges(start = c(4269,4833,5659,6470,257875,269844,271208),
                          end   = c(4692,4901,5805,6628,259073,269974,271297))
    want <- GRanges(seqnames =
                    factor(c(rep("chr1", 4), rep("chr5", 3)), levels = seqlevels),
                    ranges = wantRanges,
                    strand = strand(rep("-", 7)),
                    exon_id = c(5L, 6L, 7L, 8L, 77L, 78L, 79L),
                    seqlengths = seqlengths)
    checkIdentical(want,
                   exons(txdb,
                         vals = list(exon_chrom = c("chr1", "chr5"),
                                     exon_strand = "-")))
}

test_cds <- function()
{
    txdb <- loadFeatures(system.file("extdata", "UCSC_knownGene_sample.sqlite", 
                         package="GenomicFeatures"))
    seqlengths <- seqlengths(txdb)
    seqlevels <- names(seqlengths)

    checkException(cds(data.frame()), silent = TRUE)
    checkException(cds(txdb, vals = list("bad" = 1:10)), silent = TRUE)

    checkIdentical(cds(txdb, list("cds_id" = 91)),
                   GRanges(seqnames = factor("chr10", levels = seqlevels),
                           ranges = IRanges(start=82997, end=84054),
                           strand = strand("-"),
                           cds_id = 91L,
                           seqlengths = seqlengths))

    want <- GRanges(seqnames = factor(c("chr5", "chr5"), levels = seqlevels),
                    ranges = IRanges(start=c(258412,269844), end=c(259073,269964)),
                    strand = strand(c("-", "-")),
                    cds_id = 53:54,
                    seqlengths = seqlengths)
    checkIdentical(want,
                   cds(txdb,
                       vals = list(cds_chrom = c("chr1", "chr5"),
                                   cds_strand = "-")))
}
