###################################################
### chunk number 1: loadGenomicFeatures
###################################################
library(GenomicFeatures)


###################################################
### chunk number 2: supportedUCSCtables
###################################################
supportedUCSCtables()


###################################################
### chunk number 3: makeTranscriptDbFromUCSC eval=FALSE
###################################################
## mm9KG <- makeTranscriptDbFromUCSC(genome = "mm9", tablename = "knownGene")


###################################################
### chunk number 4: makeTranscriptDbFromBiomart eval=FALSE
###################################################
## mmusculusEnsembl <- 
##   makeTranscriptDbFromBiomart(biomart = "ensembl",
##                               dataset = "mmusculus_gene_ensembl")


###################################################
### chunk number 5: saveFeatures 1 eval=FALSE
###################################################
## saveFeatures(mm9KG, file="fileName.sqlite")


###################################################
### chunk number 6: loadFeatures-1 eval=FALSE
###################################################
## mm9KG <- loadFeatures("fileName.sqlite")


###################################################
### chunk number 7: load_UCSC_KG
###################################################
exampleFile <-
    system.file("extdata", "UCSC_knownGene_sample.sqlite",
                package="GenomicFeatures")
txdb <- loadFeatures(exampleFile)
txdb


###################################################
### chunk number 8: transcripts1
###################################################
txdb <- loadFeatures(system.file("extdata", "UCSC_knownGene_sample.sqlite",
                                 package="GenomicFeatures"))
GR <- transcripts(txdb)
GR


###################################################
### chunk number 9: transcripts2
###################################################
GR <- transcripts(txdb, vals <- list(tx_chrom = "chr1", tx_strand = "+"))
GR


###################################################
### chunk number 10: transcriptsBy
###################################################
txdb <- loadFeatures(system.file("extdata", "UCSC_knownGene_sample.sqlite",
                                 package="GenomicFeatures"))
GRList <- transcriptsBy(txdb, "gene")
GRList


###################################################
### chunk number 11: exonsBy
###################################################
txdb <- loadFeatures(system.file("extdata", "UCSC_knownGene_sample.sqlite",
                                 package="GenomicFeatures"))
GRList <- exonsBy(txdb, "tx")
GRList


###################################################
### chunk number 12: introns-UTRs
###################################################
intronsByTranscript(txdb)
fiveUTRsByTranscript(txdb)
threeUTRsByTranscript(txdb)


###################################################
### chunk number 13: transcriptsByOverlaps
###################################################
library(org.Mm.eg.db)
set.seed(0L)
idx <- sample(length(org.Mm.egCHRLOC), 50)
tbl <- unique(merge(toTable(org.Mm.egCHRLOC[idx]), 
                    toTable(org.Mm.egCHRLOCEND[idx])))
gr <- with(tbl, {
    lvls <- paste("chr", c(1:19, "X", "Y", "MT", "Un"), sep="")
    GRanges(seqnames=factor(paste("chr", Chromosome, sep=""), 
                            levels=lvls),
            ranges=IRanges(abs(start_location), abs(end_location)), 
            strand=ifelse(start_location >= 0, "+", "-"),
            egid=gene_id)
})
transcriptsByOverlaps(txdb, gr)


###################################################
### chunk number 14: RNASEQ1 eval=FALSE
###################################################
## gr <- GRanges(seqnames = rep("chr5",4),
##               ranges = IRanges(start = c(244620,244670,245804,247502),
##                                end = c(244652,244702,245836,247534)),
##               strand = rep("+",4))


###################################################
### chunk number 15: exonsGroupedByTx
###################################################
annotGr <- exonsBy(txdb, "tx")


###################################################
### chunk number 16: findOverlaps
###################################################
OL <- findOverlaps(annotGr, gr)


###################################################
### chunk number 17: getAnswers
###################################################
tdata <- annotGr[subjectHits(OL),]
tdata 

length(tdata)


###################################################
### chunk number 18: SessionInfo
###################################################
sessionInfo()


