###################################################
### chunk number 1: 
###################################################
options(width=70)


###################################################
### chunk number 2: simulateData
###################################################
set.seed(0)
data <- matrix(rnorm(4000, mean=0), nrow=100, ncol=40)
data[1:30,1:20] <- rnorm(600,mean=1)
phenotype <- factor(rep(c(0,1), each=20))
geneSetName <- "Test Gene Set"


###################################################
### chunk number 3: gsri
###################################################
library(GSRI)
res <-gsri(data, phenotype, geneSetName, plotResults=TRUE, writeResults=FALSE)


###################################################
### chunk number 4: gsriOutput
###################################################
print(res)


###################################################
### chunk number 5: gsriGrenander
###################################################
res2 <-gsri(data, phenotype, "Test Gene Set with Grenander", useGrenander=TRUE)
res2$numRegGenes


###################################################
### chunk number 6: statFcn
###################################################
statFcn <- function(d, p)  {
m <- lm(d ~ p)
pval <- summary(m)$coefficients[2,4]
}


###################################################
### chunk number 7: testFcn
###################################################
testFcn <- function(data, phenotype)  {
pvals <- apply(data, 1, statFcn, phenotype)
return(pvals)
}


###################################################
### chunk number 8: gsriOwnTest
###################################################
res3 <-gsri(data, phenotype, geneSetName, test=testFcn, plotResults=FALSE, nBootstraps=20)


###################################################
### chunk number 9: gsriFromFile
###################################################
dataFileName <- system.file("extdata", "data.gct", package="GSRI")
phenotypeFileName <- system.file("extdata", "phenotype.cls", package="GSRI")
geneSetFileName <- system.file("extdata", "geneSets.gmt", package="GSRI")
res4 <- gsriFromFile(dataFileName, phenotypeFileName, geneSetFileName)
res4$numRegGenes


###################################################
### chunk number 10: sessionInfo
###################################################
sessionInfo()


