###################################################
### chunk number 1: groupCorr
###################################################
library(CAMERA)
file <- system.file('mzdata/MM14.mzdata', package = "CAMERA")
xs   <- xcmsSet(file, method="centWave",ppm=30, peakwidth=c(5,10))
an   <- xsAnnotate(xs)
an   <- groupFWHM(an)
an  <- findIsotopes(an)
anC <- groupCorr(an, cor_eic_th = 0.75)
anCp<- groupCorr(an, cor_eic_th = 0.75, polarity="positive")
an1   <- findAdducts(anC, polarity="positive")
an2   <- findAdducts(anCp, polarity="positive")
par(mfrow=c(2,1))
plotEICs(an1, pspecIdx=8, maxlabel=5)
plotEICs(an2, pspecIdx=8, maxlabel=5)


###################################################
### chunk number 2: EICPspec1
###################################################
library(CAMERA)
file <- system.file('mzdata/MM14.mzdata', package = "CAMERA")
xs   <- xcmsSet(file, method="centWave",ppm=30, peakwidth=c(5,10))
an   <- xsAnnotate(xs)
an   <- groupFWHM(an)
an   <- findAdducts(an, polarity="positive")
plotEICs(an, pspecIdx=2, maxlabel=5)


###################################################
### chunk number 3: Pspec1
###################################################
plotPsSpectrum(an, pspec=2, maxlabel=5)


