### Name: dyebias.umcu.proper.estimators
### Title: Determine which spots should not be ruled out as slide bias
###   estimators
### Aliases: dyebias.umcu.proper.estimators
### Keywords: misc

### ** Examples


  ## Don't show: 
     library(dyebias)
     library(dyebiasexamples)
     data(data.raw)
     data(data.norm)

     ### obtain estimate for the iGSDBs:
     iGSDBs.estimated <- dyebias.estimate.iGSDBs(data.norm,
                                                 is.balanced=TRUE,
                                                 verbose=TRUE)

  ## End Don't show

  ### choose the estimators and which spots to correct:
  estimator.subset <- dyebias.umcu.proper.estimators(maInfo(maGnames(data.norm)))

  summary(estimator.subset)

  ### do the correction
  ## Not run: 
##D      correction <- dyebias.apply.correction(data.norm=data.norm,
##D                                          iGSDBs = iGSDBs.estimated,
##D                                          estimator.subset=estimator.subset,
##D                                          application.subset = TRUE,
##D                                          verbose=TRUE)
##D    
## End(Not run)



