### Name: Scerevisiae
### Title: Saccharomyces cerevisiae (Yeast) full genome (UCSC version
###   sacCer1)
### Aliases: BSgenome.Scerevisiae.UCSC.sacCer1-package
###   BSgenome.Scerevisiae.UCSC.sacCer1 Scerevisiae
### Keywords: package data

### ** Examples

Scerevisiae
seqlengths(Scerevisiae)
Scerevisiae$chr1  # same as Scerevisiae[["chr1"]]

if ("AGAPS" %in% masknames(Scerevisiae)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Scerevisiae)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Scerevisiae[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



