### Name: Ptroglodytes
### Title: Pan troglodytes (Chimp) full genome (UCSC version panTro2)
### Aliases: BSgenome.Ptroglodytes.UCSC.panTro2-package
###   BSgenome.Ptroglodytes.UCSC.panTro2 Ptroglodytes
### Keywords: package data

### ** Examples

Ptroglodytes
seqlengths(Ptroglodytes)
Ptroglodytes$chr1  # same as Ptroglodytes[["chr1"]]

if ("AGAPS" %in% masknames(Ptroglodytes)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Ptroglodytes)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Ptroglodytes[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



