### Name: Ecoli
### Title: Escherichia coli full genomes
### Aliases: BSgenome.Ecoli.NCBI.20080805-package
###   BSgenome.Ecoli.NCBI.20080805 Ecoli
### Keywords: package data

### ** Examples

## The names of the sequences are the Refseq numbers:
Ecoli
seqlengths(Ecoli)
Ecoli$NC_008253  # same as Ecoli[["NC_008253"]]

if ("AGAPS" %in% masknames(Ecoli)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Ecoli)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Ecoli[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



