### Name: Dmelanogaster
### Title: Drosophila melanogaster full genome (UCSC version dm2)
### Aliases: BSgenome.Dmelanogaster.UCSC.dm2-package
###   BSgenome.Dmelanogaster.UCSC.dm2 Dmelanogaster
### Keywords: package data

### ** Examples

Dmelanogaster
seqlengths(Dmelanogaster)
Dmelanogaster$chr2L  # same as Dmelanogaster[["chr2L"]]

if ("AGAPS" %in% masknames(Dmelanogaster)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Dmelanogaster)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Dmelanogaster[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



