### Name: Btaurus
### Title: Bos taurus (Cow) full genome (UCSC version bosTau3)
### Aliases: BSgenome.Btaurus.UCSC.bosTau3-package
###   BSgenome.Btaurus.UCSC.bosTau3 Btaurus
### Keywords: package data

### ** Examples

Btaurus
seqlengths(Btaurus)
Btaurus$chr1  # same as Btaurus[["chr1"]]

if ("AGAPS" %in% masknames(Btaurus)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    unique_letters <- uniqueLetters(seq)
    if (any(unique_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Btaurus)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Btaurus[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



