### Name: Athaliana
### Title: Arabidopsis thaliana full genome (TAIR version from January 22,
###   2004)
### Aliases: BSgenome.Athaliana.TAIR.01222004-package
###   BSgenome.Athaliana.TAIR.01222004 Athaliana
### Keywords: package data

### ** Examples

Athaliana
seqlengths(Athaliana)
Athaliana$chr1  # same as Athaliana[["chr1"]]

if ("AGAPS" %in% masknames(Athaliana)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Athaliana)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Athaliana[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



