### Name: Amellifera
### Title: Apis mellifera (Honey Bee) full genome (UCSC version apiMel2)
### Aliases: BSgenome.Amellifera.UCSC.apiMel2-package
###   BSgenome.Amellifera.UCSC.apiMel2 Amellifera
### Keywords: package data

### ** Examples

Amellifera
seqlengths(Amellifera)
Amellifera$Group1  # same as Amellifera[["Group1"]]

if ("AGAPS" %in% masknames(Amellifera)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Amellifera)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Amellifera[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



