xmap.plot             package:xmapbridge             R Documentation

_U_t_i_l_i_t_y _m_e_t_h_o_d_s _f_o_r _q_u_i_c_k _g_r_a_p_h _g_e_n_e_r_a_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     These methods attempt to provide a simpler interface for
     generating X:Map graphs.

_U_s_a_g_e:

       xmap.plot( x, y, species=c("homo_sapiens","mus_musculus","rattus_norvegicus"), 
                  chr, xlim, ylim, main, sub, 
                  type=c("scatter", "line", "bar", "step", "area", "steparea"), 
                  xlab, ylab = "value", col, dp=2, projectid )
       xmap.points( x, y, type=c("scatter", "line", "bar", "step", "area", "steparea"),
                  xlab, col, dp=2, graphid )

_A_r_g_u_m_e_n_t_s:

       x: The points for the x-axis of this plot.  These points must be
          offsets from the start of the graph, and not their actual
          chromosomal location 

       y: The points for the y-axis of this plot.  Points where min>y
          or y >max will not be displayed 

 species: The species that this graph is to be drawn on 

     chr: A string representing the chromosome this graph is to be
          drawn on 

    xlim: A range object describing the min and max BP for this graph. 
          If ommitted, we call range on the x parameter 

    ylim: The maximum and minimum Y value for the graph.  If ommitted,
          we call range on the y parameter 

    main: The main title 

     sub: A sub-title for this graph 

    type: The type of graph you wish to draw 

    xlab: The label for this plot 

    ylab: The label for the yaxis of this graph 

     col: The colour of the graph defined as an integer in the format
          0xAARRGGBB.  See 'xmap.col' 

      dp: The number of decimal places you want to save for the
          y-coordinates 

projectid: The projectid (returned by 'xmap.project.new' and as a list
          from 'xmap.project.list'.  If this is not passed, on the
          first time of calling a new project will be created, and will
          be used on all subsequent calls) 

 graphid: The graphid returned by 'xmap.graph.new' or
          'xmap.graph.list'.  If this is not passed, it will use the
          last graph generated by 'xmap.plot'. 

_A_u_t_h_o_r(_s):

     Tim Yates

_S_e_e _A_l_s_o:

     'xmap.col'
      'xmap.project.new'
      'xmap.project.list'
      'xmap.project.load'
      'xmap.project.save'
      'xmap.project.delete'
      'xmap.graph.new'
      'xmap.graph.list'
      'xmap.graph.load'
      'xmap.graph.save'
      'xmap.graph.delete'
      'xmap.plot.new'
      'xmap.plot.list'
      'xmap.plot.load'
      'xmap.plot.save'
      'xmap.plot.delete'

_E_x_a_m_p_l_e_s:

       
       x <- seq( 1000, 100000, by = 1000 )
       y <- runif( length( x ), -10, 10 )

       # This will create a new project, and graph, and add a plot to it
       xmap.plot( x, y, species="homo_sapiens", "1", main="A quick graph", 
                  sub="Sub heading", type="area", xlab="Plot 1", col=0xAAFFBB00 )

       # This will add another plot to the same graph
       xmap.points( x, y, type="area", xlab="Plot 2", col=0xAA0000FF )
       

