### Name: WName
### Title: Accessors for Primitive Widget Objects
### Aliases: WName WValue WValue<- WtoText WfromText WcanEdit WbuttonText
###   WbuttonFun WwList WwList<- "WwList<-" WLValue WLValue<- WRButtons
###   WpreFun WpostFun WEnd "WValue<-"
### Keywords: manip

### ** Examples

# Create the list of lists
pW1 <- list(Name="AAA", Value="bbb",
            toText = function(x) paste(x,collapse = ","),
            fromText = NULL, canEdit = TRUE,
            buttonFun = ls, buttonText = "Browse")

widget1 <- list(wList = list(a = pW1),
                preFun = function() "Hi",
                postFun = function() "Bye")

# Call the functions
WName(pW1)
WValue(pW1)
WValue(pW1) <- "lll"
WtoText(pW1)
WfromText(pW1)
WcanEdit(pW1)
WbuttonText(pW1)
WbuttonFun(pW1)
WwList(widget1)
WwList(widget1) <- list(Name = "New list", Value = "New value")
WLValue(widget1, 1)
WLValue(widget1, 1) <- "New value"
WpreFun(widget1)
WpostFun(widget1)
WEnd(widget1)



