### Name: UCSCTableQuery-class
### Title: Querying UCSC Tables
### Aliases: UCSCTableQuery-class browserSession,UCSCTableQuery-method
###   browserSession<- browserSession<-,UCSCTableQuery,UCSCSession-method
###   trackName trackName,UCSCTableQuery-method trackName<-
###   trackName<-,UCSCTableQuery-method tableName
###   tableName,UCSCTableQuery-method tableName<-
###   tableName<-,UCSCTableQuery-method range,UCSCTableQuery-method
###   range<-,UCSCTableQuery,RangesList-method tableNames
###   tableNames,UCSCTableQuery-method getTable
###   getTable,UCSCTableQuery-method track track,UCSCTableQuery-method
###   ucscTableQuery ucscTableQuery,UCSCSession-method
###   show,UCSCTableQuery-method
### Keywords: methods classes

### ** Examples

## Not run: 
##D session <- browserSession()
##D genome(session) <- "mm9"
##D trackNames(session) ## list the track names
##D ## choose the Conservation track for a portion of mm9 chr1
##D query <- ucscTableQuery(session, "Conservation",
##D                         GenomicRanges(57795963, 57815592, "chr12"))
##D ## list the table names
##D tableNames(query)
##D ## get the phastCons30way track
##D tableName(query) <- "phastCons30way"
##D ## retrieve the track data
##D track(query)
##D ## get a data.frame summarizing the multiple alignment
##D tableName(query) <- "multiz30waySummary"
##D getTable(query)
## End(Not run)



