fitgene.nl               package:rHVDM               R Documentation

_F_i_t_s _t_h_e _o_p_t_i_m_a_l _k_i_n_e_t_i_c _p_a_r_a_m_e_t_e_r _v_a_l_u_e_s _f_o_r _a _p_a_r_t_i_c_u_l_a_r _g_e_n_e _a_n_d _m_o_d_e_l.

_D_e_s_c_r_i_p_t_i_o_n:

     This method fits the three kinetic parameter values for a
     particular gene. It returns a list containing the results.

_U_s_a_g_e:

     fitgene.nl(eset,gene,tHVDM,transforms,firstguess,model)

_A_r_g_u_m_e_n_t_s:

    eset: an ExpressionSet object (Biobase) 

    gene: the gene identifier in character format 

transforms: a vector containing the kinetic parameter identifiers that
          have to be transformed during optimisation (optional) 

   tHVDM: the output of the training set 

firstguess: first guess for the fitting (optional, see details)

   model: model specification of the production function in character
          format" MM (Michelis-Menten, default) or hill (hill function) 

_D_e_t_a_i_l_s:

     An exponential transform is set by default for both the basal
     (Bj), degradation (Dj) and Kj rates (through the transforms
     argument). This forces the values for both these parameters to be
     positive. It also helps to reach a better fit. To turn this off
     let transforsm=c(). Even in this case the degradation rate will
     not be allowed to take non positive values as it causes problems
     with the differential operator used internally. The value in the
     vector indicates the parameter to be transformed: "Bj": basal rate
     of transcription, "Vj": sensitivity, "Dj": degrdation rate. The
     entry label indicates the transform to be applied.

     This 'fitgene.nl()' step can only be applied after a 'training()'
     step. The output to the 'training.nl()' step has to be fed through
      the 'tHVDM' argument.

     The 'firstguess' argument is optional (a first guess is generated
     internally by default).  However a first guess can be supplied by
     the user which can take several forms.  It can either be a vector
     with three entries containing a first guess for the basal rate, 
     the sensitivity, the degradation rate (in that order). 
     Alternatively, another output from the 'fitgene()' function (for
     example from a gene that has a similar expression profile) can be
     supplied as a 'firstguess' argument.

     The 'model' argument is only used to choose the model (MM:
     Michelis-Menten, hill: Hill function).

_V_a_l_u_e:

     a list containing the results (see documentation for more
     details).

_N_o_t_e:

     Obviously, the expression set given as a 'eset' argument has to be
     the same as the one used for the training step.

_A_u_t_h_o_r(_s):

     Martino Barenco

_R_e_f_e_r_e_n_c_e_s:

     M. Barenco, D. Tomescu, D. Brewer, R. Callard, J. Stark, M. Hubank
     (2006) Ranked predictions of p53 targets using Hidden Variable
     Dynamic Modelling. _Genome Biology_, *V7(3)*, R25.

_S_e_e _A_l_s_o:

     'training','screening','HVDMreport'

_E_x_a_m_p_l_e_s:

     #load data and fit a linear model
     data(HVDMexample)
     rm(fiveGyMAS5)
     data(HVDMexample2)
     tp532<-training(eset=twodosesMAS5,genes=p53traingenes,degrate=0.8)
     #formulate constraints
     CONSTRAINTS<-c(350,35)
     names(CONSTRAINTS)<-c("trfact1.5Gy.1.4","trfact1.hGy.1.4")
     #specify individual gene models
     GENEMODELS<-rep("MM",5)
     GENEMODELS[c(1,3)]<-"hill"
     names(GENEMODELS)<-p53traingenes
     #run the model
     tp53hyb<-training.nl(inputHVDM=tp532,constraints=CONSTRAINTS,genemodels=GENEMODELS)

     #fit an individual gene
     sHVDMex<-fitgene.nl(eset=twodosesMAS5,gene="213293_s_at",tHVDM=tp53hyb)

