### Name: qpPCC
### Title: Estimation of Pearson correlation coefficients
### Aliases: qpPCC qpPCC,ExpressionSet-method qpPCC,data.frame-method
###   qpPCC,matrix-method
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5 # maximum connectivity per variable
nObs <- 30 # number of observations to simulate

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

X <- qpSampleMvnorm(K, nObs)

pcc.estimates <- qpPCC(X)

# Pearson correlation coefficients of the present edges
summary(abs(pcc.estimates$R[upper.tri(pcc.estimates$R) & I]))

# Pearson correlation coefficients of the missing edges
summary(abs(pcc.estimates$R[upper.tri(pcc.estimates$R) & !I]))




