### Name: qpGraph
### Title: The qp-graph
### Aliases: qpGraph
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable
nObs <- 30 # number of observations to simulate

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

X <- qpSampleMvnorm(K, nObs)

nrr.estimates <- qpNrr(X, q=5, verbose=FALSE)

# the higher the threshold
g <- qpGraph(nrr.estimates, threshold=0.9)

# the denser the qp-graph
(sum(g)/2) / (nVar*(nVar-1)/2)

# the lower the threshold
g <- qpGraph(nrr.estimates, threshold=0.5)

# the sparser the qp-graph
(sum(g)/2) / (nVar*(nVar-1)/2)




