### Name: getRelevantEGenes
### Title: Automatic selection of most relevant effect reporters
### Aliases: getRelevantEGenes selectEGenes filterEGenes
### Keywords: models

### ** Examples

   # Drosophila RNAi and Microarray Data from Boutros et al, 2002
   data("BoutrosRNAi2002")
   D <- BoutrosRNAiDiscrete[,9:16]

   # enumerate all possible models for 4 genes
   Sgenes = unique(colnames(D))
   models <- enumerate.models(Sgenes)  
   
   getRelevantEGenes(models[[64]], D, control=set.default.parameters(Sgenes, para=c(.13,.05), type="mLL"))




