### Name: miRNApath-package
### Title: miRNApath: Pathway Enrichment for miRNA Expression Data
### Aliases: miRNApath-package
### Keywords: package htest

### ** Examples

## Not run: 
##D ## Start with miRNA data from this package
##D data(mirnaobj);
##D 
##D ## Write a file as example of required input
##D write.table(mirnaobj@mirnaTable, file = "mirnaTable.txt", 
##D     quote = FALSE, row.names = FALSE, col.names = TRUE, na = "",
##D     sep = "\t");
##D 
##D ## Now essentially load it back, but assign column headers
##D mirnaobj <- loadmirnapath( mirnafile = "mirnaTable.txt",
##D     pvaluecol = "P-value", groupcol = "GROUP", 
##D     mirnacol = "miRNA Name", assayidcol = "ASSAYID" );
##D 
##D ## Start with miRNA data from this package
##D data(mirnaobj);
##D 
##D ## Write a file as example of required input
##D write.table(mirnaobj@mirnaGene, file = "mirnaGene.txt", 
##D     quote = FALSE, row.names = FALSE, col.names = TRUE, na = "",
##D     sep = "\t");
##D 
##D ## Load the miRNA to gene associations
##D mirnaobj <- loadmirnatogene( mirnafile = "mirnaGene.txt",
##D     mirnaobj = mirnaobj, mirnacol = "miRNA Name",
##D     genecol = "Entrez Gene ID", 
##D     columns = c(assayidcol = "ASSAYID") );
##D 
##D ## Write a file as example of required input
##D write.table(mirnaobj@mirnaPathways, file = "mirnaPathways.txt", 
##D     quote = FALSE, row.names = FALSE, col.names = TRUE, na = "",
##D     sep = "\t");
##D 
##D ## Load the gene to pathway associations
##D mirnaobj <- loadmirnapathways( mirnaobj = mirnaobj, 
##D     pathwayfile = "mirnaPathways.txt", 
##D     pathwaycol = "Pathway Name", genecol = "Entrez Gene ID");
##D 
##D ## Annotate hits by filtering by P-value 0.05
##D mirnaobj <- filtermirnapath( mirnaobj, pvalue = 0.05,
##D     expression = NA, foldchange = NA );
##D 
##D ## Now run enrichment test
##D mirnaobj <- runEnrichment( mirnaobj=mirnaobj, Composite=TRUE,
##D    groups=NULL, permutations=0 );
##D 
##D ## Print out a summary table of significant results
##D finaltable <- mirnaTable( mirnaobj, groups=NULL, format="Tall", 
##D     Significance=0.1, pvalueTypes=c("pvalues") );
##D finaltable[1:4,];
##D 
##D ## Example which calls heatmap function on the resulting data
##D widetable <- mirnaTable( mirnaobj, groups=NULL, format="Wide", 
##D     Significance=0.1, na.char=NA, pvalueTypes=c("pvalues") );
##D ## Assign 1 to NA values, assuming they're all equally
##D ## non-significant
##D widetable[is.na(widetable)] <- 1;
##D 
##D ## Display a heatmap of the result across sample groups
##D pathwaycol <- mirnaobj@columns["pathwaycol"];
##D pathwayidcol <- mirnaobj@columns["pathwayidcol"];
##D rownames(widetable) <- apply(widetable[,c(pathwaycol,
##D    pathwayidcol)], 1, function(i)paste(i, collapse="-"));
##D wt <- as.matrix(widetable[3:dim(widetable)[2]], mode="numeric")
##D heatmap(wt, scale="col");
##D 
##D ## Show results where pathways are shared in four or more
##D ## sample groups
##D pathwaySubset <- apply(wt, 1, function(i)
##D {
##D    length(i[i < 1]) >= 4;
##D } )
##D heatmap(wt[pathwaySubset,], scale="row");
## End(Not run)



