/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.datamatrix;

import java.util.HashMap;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;
import org.systemsbiology.gaggle.experiment.datamatrix.LensedDataMatrix;
import org.systemsbiology.gaggle.experiment.metadata.DataSetDescription;
import org.systemsbiology.gaggle.experiment.metadata.MetaData;
import org.systemsbiology.gaggle.experiment.readers.DataMatrixFileReader;

public class MatrixSlicer {
    MetaData experiment;

    public MatrixSlicer(MetaData experiment) {
        this.experiment = experiment;
    }

    public HashMap slice() throws Exception {
        HashMap<String, DataMatrix> result = new HashMap<String, DataMatrix>();
        DataSetDescription[] dsd = this.experiment.getDataSetDescriptions();
        for (int i = 0; i < dsd.length; ++i) {
            String uri = dsd[i].getUri();
            DataMatrixFileReader reader = new DataMatrixFileReader(uri);
            reader.read();
            DataMatrix matrix = reader.get();
            LensedDataMatrix lens = new LensedDataMatrix(matrix);
            matrix.setSpecies(this.experiment.getSpecies());
            lens.setSpecies(this.experiment.getSpecies());
            lens.enableAllColumns();
            lens.enableAllRows();
            String[] allLensColumnTitles = lens.getColumnTitles();
            String[] selectedConditions = this.experiment.getSelectedConditionsAsAliases();
            lens.disableAllColumns();
            for (int c = 0; c < selectedConditions.length; ++c) {
                for (int d = 0; d < allLensColumnTitles.length; ++d) {
                    String lensColumn = allLensColumnTitles[d];
                    String selectedColumn = selectedConditions[c];
                    if (!lensColumn.equals(selectedColumn)) continue;
                    lens.setColumnState(d, true);
                }
            }
            String matrixType = dsd[i].getType();
            result.put(matrixType, lens.getVisibleMatrix());
        }
        return result;
    }
}

